/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.PlayerUtils;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.events.EvtClick;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Cancel Event")
@Description(value={"Cancels the event (e.g. prevent blocks from being placed, or damage being taken)."})
@Examples(value={"on damage:", "\tvictim is a player", "\tvictim has the permission \"skript.god\"", "\tcancel the event"})
@Since(value="1.0")
public class EffCancelEvent
extends Effect {
    private boolean cancel;

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (isDelayed == Kleenean.TRUE) {
            Skript.error("Can't cancel an event anymore after it has already passed", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.cancel = matchedPattern == 0;
        Class<? extends Event>[] es = this.getParser().getCurrentEvents();
        if (es == null) {
            return false;
        }
        for (Class<? extends Event> e : es) {
            if (!Cancellable.class.isAssignableFrom(e) && !BlockCanBuildEvent.class.isAssignableFrom(e)) continue;
            return true;
        }
        if (this.getParser().isCurrentEvent((Class<? extends Event>)PlayerLoginEvent.class)) {
            Skript.error("A connect event cannot be cancelled, but the player may be kicked ('kick player by reason of \"...\"')", ErrorQuality.SEMANTIC_ERROR);
        } else {
            Skript.error(Utils.A(this.getParser().getCurrentEventName()) + " event cannot be cancelled", ErrorQuality.SEMANTIC_ERROR);
        }
        return false;
    }

    @Override
    public void execute(Event e) {
        if (e instanceof Cancellable) {
            ((Cancellable)e).setCancelled(this.cancel);
        }
        if (e instanceof PlayerInteractEvent) {
            EvtClick.interactTracker.eventModified((Cancellable)e);
            ((PlayerInteractEvent)e).setUseItemInHand(this.cancel ? Event.Result.DENY : Event.Result.DEFAULT);
            ((PlayerInteractEvent)e).setUseInteractedBlock(this.cancel ? Event.Result.DENY : Event.Result.DEFAULT);
        } else if (e instanceof BlockCanBuildEvent) {
            ((BlockCanBuildEvent)e).setBuildable(!this.cancel);
        } else if (e instanceof PlayerDropItemEvent) {
            PlayerUtils.updateInventory(((PlayerDropItemEvent)e).getPlayer());
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return (this.cancel ? "" : "un") + "cancel event";
    }

    static {
        Skript.registerEffect(EffCancelEvent.class, "cancel [the] event", "uncancel [the] event");
    }
}

