/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.HealthUtils;
import ch.njol.skript.bukkitutil.ItemUtils;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.Math2;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Damage/Heal/Repair")
@Description(value={"Damage/Heal/Repair an entity, or item."})
@Examples(value={"damage player by 5 hearts", "heal the player", "repair tool of player"})
@Since(value="1.0")
public class EffHealth
extends Effect {
    private Expression<?> damageables;
    @Nullable
    private Expression<Number> damage;
    private boolean heal = false;
    @Nullable
    private Expression<EntityDamageEvent.DamageCause> damageCause;

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.damageables = vars[0];
        if (ItemStack.class.isAssignableFrom(this.damageables.getReturnType()) && !Changer.ChangerUtils.acceptsChange(this.damageables, Changer.ChangeMode.SET, ItemType.class)) {
            Skript.error(this.damageables + " cannot be changed, thus it cannot be damaged or repaired.");
            return false;
        }
        this.damage = vars[1];
        boolean bl = this.heal = matchedPattern >= 1;
        if (vars.length >= 3) {
            this.damageCause = vars[2];
        }
        return true;
    }

    @Override
    public void execute(Event e) {
        ?[] arr;
        double damage = 0.0;
        if (this.damage != null) {
            Number n = this.damage.getSingle(e);
            if (n == null) {
                return;
            }
            damage = n.doubleValue();
        }
        if ((arr = this.damageables.getArray(e)).length > 0 && arr[0] instanceof ItemType) {
            Object[] newarr = new ItemType[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                ItemStack is = ((ItemType)arr[i]).getRandom();
                assert (is != null);
                if (this.damage == null) {
                    ItemUtils.setDamage(is, 0);
                } else {
                    ItemUtils.setDamage(is, (int)Math2.fit(0.0, (double)ItemUtils.getDamage(is) + (this.heal ? -damage : damage), (double)is.getType().getMaxDurability()));
                }
                newarr[i] = new ItemType(is);
            }
            this.damageables.acceptChange(Changer.ChangeMode.SET);
            this.damageables.change(e, newarr, Changer.ChangeMode.SET);
        } else {
            for (Object damageable : arr) {
                LivingEntity entity = (LivingEntity)damageable;
                assert (entity != null);
                if (!this.heal) {
                    EntityDamageEvent.DamageCause cause = EntityDamageEvent.DamageCause.CUSTOM;
                    if (this.damageCause != null) {
                        cause = this.damageCause.getSingle(e);
                    }
                    assert (cause != null);
                    HealthUtils.setDamageCause((Damageable)entity, cause);
                    HealthUtils.damage((Damageable)entity, damage);
                    continue;
                }
                if (this.damage == null) {
                    HealthUtils.setHealth((Damageable)entity, HealthUtils.getMaxHealth((Damageable)entity));
                    continue;
                }
                HealthUtils.heal((Damageable)entity, damage);
            }
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return (this.heal ? "heal " : "damage ") + this.damageables.toString(e, debug) + (this.damage != null ? " by " + this.damage.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffHealth.class, "damage %livingentities/itemtypes% by %number% [heart[s]][ with fake cause %-damagecause%]", "heal %livingentities% [by %-number% [heart[s]]]", "repair %itemtypes% [by %-number%]");
    }
}

