/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.util.CachedServerIcon;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Load Server Icon")
@Description(value={"Loads server icons from the given files. You can get the loaded icon using the", "<a href='expressions.html#ExprLastLoadedServerIcon'>last loaded server icon</a> expression.", "Please note that the image must be 64x64 and the file path starts from the server folder."})
@Examples(value={"on load:", "\tclear {server-icons::*}", "\tloop 5 times:", "\t\tload server icon from file \"icons/%loop-number%.png\"", "\t\tadd the last loaded server icon to {server-icons::*}", "", "on server list ping:", "\tset the icon to a random server icon out of {server-icons::*}"})
@Since(value="2.3")
@RequiredPlugins(value={"Paper 1.12.2 or newer"})
public class EffLoadServerIcon
extends AsyncEffect {
    private static final boolean PAPER_EVENT_EXISTS;
    private Expression<String> path;
    @Nullable
    public static CachedServerIcon lastLoaded;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        if (!PAPER_EVENT_EXISTS) {
            Skript.error("The load server icon effect requires Paper 1.12.2 or newer");
            return false;
        }
        this.path = exprs[0];
        return true;
    }

    @Override
    protected void execute(Event e) {
        String pathString = this.path.getSingle(e);
        if (pathString == null) {
            return;
        }
        Path p = Paths.get(pathString, new String[0]);
        if (Files.isRegularFile(p, new LinkOption[0])) {
            try {
                lastLoaded = Bukkit.loadServerIcon((File)p.toFile());
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
            }
            catch (Exception ex) {
                Skript.exception((Throwable)ex, new String[0]);
            }
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "load server icon from file " + this.path.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffLoadServerIcon.class, "load [the] server icon (from|of) [the] [image] [file] %string%");
        PAPER_EVENT_EXISTS = Skript.classExists("com.destroystokyo.paper.event.server.PaperServerListPingEvent");
        lastLoaded = null;
    }
}

