/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Locale;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Play Sound")
@Description(value={"Plays a sound at given location for everyone or just for given players, or plays a sound to specified players. Both Minecraft sound names and <a href=\"https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Sound.html\">Spigot sound names</a> are supported. Playing resource pack sounds are supported too. The sound category is 'master' by default. ", "", "Please note that sound names can get changed in any Minecraft or Spigot version, or even removed from Minecraft itself."})
@Examples(value={"play sound \"block.note_block.pling\" # It is block.note.pling in 1.12.2", "play sound \"entity.experience_orb.pickup\" with volume 0.5 to the player", "play sound \"custom.music.1\" in jukebox category at {speakerBlock}"})
@Since(value="2.2-dev28, 2.4 (sound categories)")
@RequiredPlugins(value={"Minecraft 1.11+ (sound categories)"})
public class EffPlaySound
extends Effect {
    private static final boolean SOUND_CATEGORIES_EXIST = Skript.classExists("org.bukkit.SoundCategory");
    private static final Pattern SOUND_VALID_PATTERN = Pattern.compile("[a-z0-9\\/:._-]+");
    private Expression<String> sounds;
    @Nullable
    private Expression<SoundCategory> category;
    @Nullable
    private Expression<Number> volume;
    @Nullable
    private Expression<Number> pitch;
    @Nullable
    private Expression<Location> locations;
    @Nullable
    private Expression<Player> players;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.sounds = exprs[0];
        if (SOUND_CATEGORIES_EXIST) {
            this.category = exprs[1];
            this.volume = exprs[2];
            this.pitch = exprs[3];
            if (matchedPattern == 0) {
                this.locations = exprs[4];
                this.players = exprs[5];
            } else {
                this.players = exprs[4];
                this.locations = exprs[5];
            }
        } else {
            this.volume = exprs[1];
            this.pitch = exprs[2];
            if (matchedPattern == 0) {
                this.locations = exprs[3];
                this.players = exprs[4];
            } else {
                this.players = exprs[3];
                this.locations = exprs[4];
            }
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        block13: {
            float pitch;
            float volume;
            SoundCategory category;
            block12: {
                category = null;
                if (SOUND_CATEGORIES_EXIST) {
                    category = SoundCategory.MASTER;
                    if (this.category != null && (category = this.category.getSingle(e)) == null) {
                        return;
                    }
                }
                volume = 1.0f;
                pitch = 1.0f;
                if (this.volume != null) {
                    Number volumeNumber = this.volume.getSingle(e);
                    if (volumeNumber == null) {
                        return;
                    }
                    volume = volumeNumber.floatValue();
                }
                if (this.pitch != null) {
                    Number pitchNumber = this.pitch.getSingle(e);
                    if (pitchNumber == null) {
                        return;
                    }
                    pitch = pitchNumber.floatValue();
                }
                if (this.players == null) break block12;
                if (this.locations == null) {
                    for (Player player : this.players.getArray(e)) {
                        EffPlaySound.playSound(player, player.getLocation(), this.sounds.getArray(e), category, volume, pitch);
                    }
                } else {
                    for (Player player : this.players.getArray(e)) {
                        for (Location location : this.locations.getArray(e)) {
                            EffPlaySound.playSound(player, location, this.sounds.getArray(e), category, volume, pitch);
                        }
                    }
                }
                break block13;
            }
            if (this.locations == null) break block13;
            for (Player player : this.locations.getArray(e)) {
                EffPlaySound.playSound((Location)player, this.sounds.getArray(e), category, volume, pitch);
            }
        }
    }

    private static void playSound(Player p, Location location, String[] sounds, SoundCategory category, float volume, float pitch) {
        for (String sound : sounds) {
            Sound soundEnum = null;
            try {
                soundEnum = Sound.valueOf((String)sound.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (SOUND_CATEGORIES_EXIST) {
                if (soundEnum == null) {
                    if (!SOUND_VALID_PATTERN.matcher(sound = sound.toLowerCase(Locale.ENGLISH)).matches()) continue;
                    p.playSound(location, sound, category, volume, pitch);
                    continue;
                }
                p.playSound(location, soundEnum, category, volume, pitch);
                continue;
            }
            if (soundEnum == null) {
                if (!SOUND_VALID_PATTERN.matcher(sound = sound.toLowerCase(Locale.ENGLISH)).matches()) continue;
                p.playSound(location, sound, volume, pitch);
                continue;
            }
            p.playSound(location, soundEnum, volume, pitch);
        }
    }

    private static void playSound(Location location, String[] sounds, SoundCategory category, float volume, float pitch) {
        World w = location.getWorld();
        for (String sound : sounds) {
            Sound soundEnum = null;
            try {
                soundEnum = Sound.valueOf((String)sound.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (SOUND_CATEGORIES_EXIST) {
                if (soundEnum == null) {
                    if (!SOUND_VALID_PATTERN.matcher(sound = sound.toLowerCase(Locale.ENGLISH)).matches()) continue;
                    w.playSound(location, sound, category, volume, pitch);
                    continue;
                }
                w.playSound(location, soundEnum, category, volume, pitch);
                continue;
            }
            if (soundEnum == null) {
                if (!SOUND_VALID_PATTERN.matcher(sound = sound.toLowerCase(Locale.ENGLISH)).matches()) continue;
                w.playSound(location, sound, volume, pitch);
                continue;
            }
            w.playSound(location, soundEnum, volume, pitch);
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (this.locations != null) {
            return "play sound " + this.sounds.toString(e, debug) + (this.category != null ? " in " + this.category.toString(e, debug) : "") + (this.volume != null ? " at volume " + this.volume.toString(e, debug) : "") + (this.pitch != null ? " at pitch " + this.pitch.toString(e, debug) : "") + (this.locations != null ? " at " + this.locations.toString(e, debug) : "") + (this.players != null ? " for " + this.players.toString(e, debug) : "");
        }
        return "play sound " + this.sounds.toString(e, debug) + (this.volume != null ? " at volume " + this.volume.toString(e, debug) : "") + (this.pitch != null ? " at pitch " + this.pitch.toString(e, debug) : "") + (this.players != null ? " to " + this.players.toString(e, debug) : "");
    }

    static {
        if (SOUND_CATEGORIES_EXIST) {
            Skript.registerEffect(EffPlaySound.class, "play sound[s] %strings% [(in|from) %-soundcategory%] [(at|with) volume %-number%] [(and|at|with) pitch %-number%] at %locations% [for %-players%]", "play sound[s] %strings% [(in|from) %-soundcategory%] [(at|with) volume %-number%] [(and|at|with) pitch %-number%] [(to|for) %players%] [(at|from) %-locations%]");
        } else {
            Skript.registerEffect(EffPlaySound.class, "play sound[s] %strings% [(at|with) volume %-number%] [(and|at|with) pitch %-number%] at %locations% [for %-players%]", "play sound[s] %strings% [(at|with) volume %-number%] [(and|at|with) pitch %-number%] [(to|for) %players%] [(at|from) %-locations%]");
        }
    }
}

