/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Push")
@Description(value={"Push entities around."})
@Examples(value={"push the player upwards", "push the victim downwards at speed 0.5"})
@Since(value="1.4.6")
public class EffPush
extends Effect {
    private Expression<Entity> entities;
    private Expression<Direction> direction;
    @Nullable
    private Expression<Number> speed = null;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.direction = exprs[1];
        this.speed = exprs[2];
        return true;
    }

    @Override
    protected void execute(Event e) {
        Entity[] ents;
        Number v;
        Direction d = this.direction.getSingle(e);
        if (d == null) {
            return;
        }
        Number number = v = this.speed != null ? (Number)this.speed.getSingle(e) : (Number)null;
        if (this.speed != null && v == null) {
            return;
        }
        for (Entity en : ents = this.entities.getArray(e)) {
            assert (en != null);
            Vector mod = d.getDirection(en);
            if (v != null) {
                mod.normalize().multiply(v.doubleValue());
            }
            en.setVelocity(en.getVelocity().add(mod));
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "push " + this.entities.toString(e, debug) + " " + this.direction.toString(e, debug) + (this.speed != null ? " at speed " + this.speed.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffPush.class, "(push|thrust) %entities% %direction% [(at|with) (speed|velocity|force) %-number%]");
    }
}

