/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityType;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Spawn")
@Description(value={"Spawn a creature."})
@Examples(value={"spawn 3 creepers at the targeted block", "spawn a ghast 5 meters above the player"})
@Since(value="1.0")
public class EffSpawn
extends Effect {
    private Expression<Location> locations;
    private Expression<EntityType> types;
    @Nullable
    private Expression<Number> amount;
    @Nullable
    public static Entity lastSpawned;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.amount = matchedPattern == 0 ? null : exprs[0];
        this.types = exprs[matchedPattern];
        this.locations = Direction.combine(exprs[1 + matchedPattern], exprs[2 + matchedPattern]);
        return true;
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void execute(Event e) {
        Integer a;
        lastSpawned = null;
        Number number = a = this.amount != null ? (Number)this.amount.getSingle(e) : (Number)1;
        if (a == null) {
            return;
        }
        EntityType[] ts = this.types.getArray(e);
        for (Location l : this.locations.getArray(e)) {
            assert (l != null) : this.locations;
            for (EntityType type : ts) {
                int i = 0;
                while ((double)i < ((Number)a).doubleValue() * (double)type.getAmount()) {
                    lastSpawned = type.data.spawn(l);
                    ++i;
                }
            }
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "spawn " + (this.amount != null ? this.amount.toString(e, debug) + " " : "") + this.types.toString(e, debug) + " " + this.locations.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSpawn.class, "(spawn|summon) %entitytypes% [%directions% %locations%]", "(spawn|summon) %number% of %entitytypes% [%directions% %locations%]");
        lastSpawned = null;
    }
}

