/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.paperlib.PaperLib;
import ch.njol.skript.timings.SkriptTimings;
import ch.njol.skript.util.Direction;
import ch.njol.skript.variables.Variables;
import ch.njol.skript.variables.VariablesMap;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Teleport")
@Description(value={"Teleport an entity to a specific location."})
@Examples(value={"teleport the player to {homes.%player%}", "teleport the attacker to the victim"})
@Since(value="1.0")
public class EffTeleport
extends Effect {
    private Expression<Entity> entities;
    private Expression<Location> location;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.entities = exprs[0];
        this.location = Direction.combine(exprs[1], exprs[2]);
        return true;
    }

    @Override
    @Nullable
    protected TriggerItem walk(Event e) {
        boolean moveEvent;
        this.debug(e, true);
        TriggerItem next = this.getNext();
        boolean delayed = Delay.isDelayed(e);
        Delay.addDelayedEvent(e);
        Location loc = this.location.getSingle(e);
        Entity[] entityArray = this.entities.getArray(e);
        boolean respawnEvent = !delayed && e instanceof PlayerRespawnEvent && entityArray.length == 1 && entityArray[0].equals(((PlayerRespawnEvent)e).getPlayer());
        boolean bl = moveEvent = !delayed && e instanceof PlayerMoveEvent && entityArray.length == 1 && entityArray[0].equals(((PlayerMoveEvent)e).getPlayer());
        if (respawnEvent && loc != null) {
            ((PlayerRespawnEvent)e).setRespawnLocation(this.getSafeLocation(loc));
        }
        if (moveEvent && loc != null) {
            ((PlayerMoveEvent)e).setTo(this.getSafeLocation(loc));
        }
        if (respawnEvent || moveEvent || loc == null) {
            this.continueWalk(next, e);
            return null;
        }
        VariablesMap localVars = Variables.removeLocals(e);
        PaperLib.getChunkAtAsync(loc).thenAccept(chunk -> {
            for (Entity entity : entityArray) {
                entity.teleport(this.getSafeLocation(loc));
            }
            if (localVars != null) {
                Variables.setLocalVariables(e, localVars);
            }
            this.continueWalk(next, e);
        });
        return null;
    }

    private void continueWalk(@Nullable TriggerItem next, Event e) {
        Object timing = null;
        if (next != null) {
            Trigger trigger;
            if (SkriptTimings.enabled() && (trigger = this.getTrigger()) != null) {
                timing = SkriptTimings.start(trigger.getDebugLabel());
            }
            TriggerItem.walk(next, e);
        }
        Variables.removeLocals(e);
        SkriptTimings.stop(timing);
    }

    private Location getSafeLocation(Location loc) {
        Block on;
        Location toLoc = loc;
        if (Math.abs(toLoc.getX() - (double)toLoc.getBlockX() - 0.5) < 1.0E-10 && Math.abs(toLoc.getZ() - (double)toLoc.getBlockZ() - 0.5) < 1.0E-10 && (on = toLoc.getBlock().getRelative(BlockFace.DOWN)).getType() != Material.AIR) {
            toLoc = toLoc.clone();
        }
        return toLoc;
    }

    @Override
    protected void execute(Event e) {
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "teleport " + this.entities.toString(e, debug) + " to " + this.location.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffTeleport.class, "teleport %entities% (to|%direction%) %location%");
    }
}

