/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.PassengerUtils;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vehicle")
@Description(value={"Makes an entity ride another entity, e.g. a minecart, a saddled pig, an arrow, etc."})
@Examples(value={"make the player ride a saddled pig", "make the attacker ride the victim"})
@Since(value="2.0")
public class EffVehicle
extends Effect {
    @Nullable
    private Expression<Entity> passengers;
    @Nullable
    private Expression<?> vehicles;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.passengers = matchedPattern == 2 ? null : exprs[0];
        Expression<?> expression = this.vehicles = matchedPattern == 1 ? null : exprs[exprs.length - 1];
        if (!PassengerUtils.hasMultiplePassenger() && this.passengers != null && this.vehicles != null && !this.passengers.isSingle() && this.vehicles.isSingle() && Entity.class.isAssignableFrom(this.vehicles.getReturnType())) {
            Skript.warning("An entity can only have one passenger");
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        Expression<?> vehicles = this.vehicles;
        Expression<Entity> passengers = this.passengers;
        if (vehicles == null) {
            assert (passengers != null);
            for (Entity p : passengers.getArray(e)) {
                p.leaveVehicle();
            }
            return;
        }
        if (passengers == null) {
            assert (vehicles != null);
            for (Object v : vehicles.getArray(e)) {
                ((Entity)v).eject();
            }
            return;
        }
        ?[] vs = vehicles.getArray(e);
        if (vs.length == 0) {
            return;
        }
        Entity[] ps = passengers.getArray(e);
        if (ps.length == 0) {
            return;
        }
        for (Object v : vs) {
            if (v instanceof Entity) {
                ((Entity)v).eject();
                for (Entity p : ps) {
                    assert (p != null);
                    p.leaveVehicle();
                    PassengerUtils.addPassenger((Entity)v, p);
                }
                continue;
            }
            for (Entity p : ps) {
                assert (p != null) : passengers;
                Object en = ((EntityData)v).spawn(p.getLocation());
                if (en == null) {
                    return;
                }
                PassengerUtils.addPassenger(en, p);
            }
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        Expression<?> vehicles = this.vehicles;
        Expression<Entity> passengers = this.passengers;
        if (vehicles == null) {
            assert (passengers != null);
            return "make " + passengers.toString(e, debug) + " dismount";
        }
        if (passengers == null) {
            assert (vehicles != null);
            return "eject passenger" + (vehicles.isSingle() ? "" : "s") + " of " + vehicles.toString(e, debug);
        }
        return "make " + passengers.toString(e, debug) + " ride " + vehicles.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffVehicle.class, "(make|let|force) %entities% [to] (ride|mount) [(in|on)] %" + (PassengerUtils.hasMultiplePassenger() ? "entities" : "entity") + "/entitydatas%", "(make|let|force) %entities% [to] (dismount|(dismount|leave) (from|of|) (any|the[ir]|his|her|) vehicle[s])", "(eject|dismount) (any|the|) passenger[s] (of|from) %entities%");
    }
}

