/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.localization.Language;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.entity.Panda;
import org.eclipse.jdt.annotation.Nullable;

public class PandaData
extends EntityData<Panda> {
    @Nullable
    private Panda.Gene mainGene = null;
    @Nullable
    private Panda.Gene hiddenGene = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PandaData() {
    }

    public PandaData(@Nullable Panda.Gene mainGene, @Nullable Panda.Gene hiddenGene) {
        this.mainGene = mainGene;
        this.hiddenGene = hiddenGene;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (exprs[0] != null) {
            this.mainGene = (Panda.Gene)exprs[0].getSingle();
        }
        if (exprs[1] != null) {
            this.hiddenGene = (Panda.Gene)exprs[1].getSingle();
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Panda> c, @Nullable Panda panda) {
        if (panda != null) {
            this.mainGene = panda.getMainGene();
            this.hiddenGene = panda.getHiddenGene();
        }
        return true;
    }

    @Override
    public void set(Panda entity) {
        Panda.Gene gen = this.mainGene;
        if (gen == null) {
            gen = Panda.Gene.values()[ThreadLocalRandom.current().nextInt(0, 7)];
        }
        if (!$assertionsDisabled && gen == null) {
            throw new AssertionError();
        }
        entity.setMainGene(gen);
        entity.setHiddenGene(this.hiddenGene != null ? this.hiddenGene : gen);
    }

    @Override
    protected boolean match(Panda entity) {
        if (this.hiddenGene != null) {
            if (this.mainGene != null) {
                return this.mainGene == entity.getMainGene() && this.hiddenGene == entity.getHiddenGene();
            }
            return this.hiddenGene == entity.getHiddenGene();
        }
        if (this.mainGene != null) {
            return this.mainGene == entity.getMainGene();
        }
        return true;
    }

    @Override
    public Class<? extends Panda> getType() {
        return Panda.class;
    }

    @Override
    public EntityData getSuperType() {
        return new PandaData(this.mainGene, this.hiddenGene);
    }

    @Override
    protected int hashCode_i() {
        int prime = 7;
        int result = 0;
        result = result * prime + (this.mainGene != null ? this.mainGene.hashCode() : 0);
        result = result * prime + (this.hiddenGene != null ? this.hiddenGene.hashCode() : 0);
        return result;
    }

    @Override
    protected boolean equals_i(EntityData<?> data) {
        if (!(data instanceof PandaData)) {
            return false;
        }
        PandaData d = (PandaData)data;
        return d.mainGene == this.mainGene && d.hiddenGene == this.hiddenGene;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> data) {
        if (!(data instanceof PandaData)) {
            return false;
        }
        PandaData d = (PandaData)data;
        return !(this.mainGene != null && this.mainGene != d.mainGene || this.hiddenGene != null && this.hiddenGene != d.hiddenGene);
    }

    @Override
    public String toString(int flags) {
        StringBuilder builder = new StringBuilder();
        if (this.mainGene != null) {
            builder.append(Language.getList("genes." + this.mainGene.name())[0]).append(" ");
        }
        if (this.hiddenGene != null && this.hiddenGene != this.mainGene) {
            builder.append(Language.getList("genes." + this.hiddenGene.name())[0]).append(" ");
        }
        builder.append(Language.get("panda"));
        return builder.toString();
    }

    static {
        boolean bl = $assertionsDisabled = !PandaData.class.desiredAssertionStatus();
        if (Skript.isRunningMinecraft(1, 14)) {
            EntityData.register(PandaData.class, "panda", Panda.class, "panda");
        }
    }
}

