/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.entity.Skeleton;
import org.eclipse.jdt.annotation.Nullable;

public class SkeletonData
extends EntityData<Skeleton> {
    private static final boolean hasWither = Skript.methodExists(Skeleton.class, "getSkeletonType", new Class[0]);
    private static final boolean hasStray = Skript.isRunningMinecraft(1, 10);
    private static final boolean separateClasses = Skript.isRunningMinecraft(1, 11);
    private int type;
    public static final int NORMAL = 0;
    public static final int WITHER = 1;
    public static final int STRAY = 2;
    public static final int LAST_INDEX = 2;

    public SkeletonData() {
    }

    public SkeletonData(int type) {
        if (type > 2) {
            throw new SkriptAPIException("Unsupported skeleton type " + type);
        }
        this.type = type;
    }

    public boolean isWither() {
        return this.type == 1;
    }

    public boolean isStray() {
        return this.type == 2;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.type = matchedPattern;
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Skeleton> c, @Nullable Skeleton e) {
        if (e == null) {
            return true;
        }
        if (hasWither && e.getSkeletonType() == Skeleton.SkeletonType.WITHER) {
            this.type = 1;
        }
        if (hasStray && e.getSkeletonType() == Skeleton.SkeletonType.STRAY) {
            this.type = 2;
        }
        return true;
    }

    @Override
    protected boolean deserialize(String s) {
        try {
            int typeOffer = Integer.parseInt(s);
            if (typeOffer > 2) {
                throw new SkriptAPIException("Unsupported skeleton type " + s);
            }
        }
        catch (NumberFormatException e) {
            throw new SkriptAPIException("Cannot parse skeleton type " + s);
        }
        return true;
    }

    @Override
    public void set(Skeleton e) {
        switch (this.type) {
            case 1: {
                e.setSkeletonType(Skeleton.SkeletonType.WITHER);
                break;
            }
            case 2: {
                e.setSkeletonType(Skeleton.SkeletonType.STRAY);
                break;
            }
            default: {
                e.setSkeletonType(Skeleton.SkeletonType.NORMAL);
            }
        }
    }

    @Override
    protected boolean match(Skeleton e) {
        switch (this.type) {
            case 1: {
                return e.getSkeletonType() == Skeleton.SkeletonType.WITHER;
            }
            case 2: {
                return e.getSkeletonType() == Skeleton.SkeletonType.STRAY;
            }
        }
        return e.getSkeletonType() == Skeleton.SkeletonType.NORMAL;
    }

    @Override
    public Class<? extends Skeleton> getType() {
        return Skeleton.class;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof SkeletonData)) {
            return false;
        }
        SkeletonData other = (SkeletonData)obj;
        return other.type == this.type;
    }

    @Override
    protected int hashCode_i() {
        return this.type;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (e instanceof SkeletonData) {
            return ((SkeletonData)e).type == this.type;
        }
        return false;
    }

    @Override
    public EntityData getSuperType() {
        return new SkeletonData(this.type);
    }

    static {
        if (!separateClasses) {
            if (hasStray) {
                EntityData.register(SkeletonData.class, "skeleton", Skeleton.class, 0, "skeleton", "wither skeleton", "stray");
            } else if (hasWither) {
                EntityData.register(SkeletonData.class, "skeleton", Skeleton.class, 0, "skeleton", "wither skeleton");
            } else {
                EntityData.register(SkeletonData.class, "skeleton", Skeleton.class, "skeleton");
            }
        }
    }
}

