/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.events.bukkit.ScheduledEvent;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Time;
import ch.njol.util.Math2;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

@SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
public class EvtAtTime
extends SelfRegisteringSkriptEvent
implements Comparable<EvtAtTime> {
    private static final int CHECKPERIOD = 10;
    static final HashMap<World, EvtAtInfo> triggers;
    @Nullable
    private Trigger t;
    int tick;
    private transient World[] worlds;
    @Nullable
    private String[] worldNames = null;
    private static int taskID;

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.tick = ((Time)args[0].getSingle()).getTicks();
        World[] worldArray = this.worlds = args[1] == null ? Bukkit.getWorlds().toArray(new World[0]) : (World[])args[1].getAll();
        if (args[1] != null) {
            this.worldNames = new String[this.worlds.length];
            for (int i = 0; i < this.worlds.length; ++i) {
                this.worldNames[i] = this.worlds[i].getName();
            }
        }
        return true;
    }

    private static void registerListener() {
        if (taskID != -1) {
            return;
        }
        taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Skript.getInstance(), new Runnable(){

            @Override
            public void run() {
                for (Map.Entry<World, EvtAtInfo> e : triggers.entrySet()) {
                    boolean midnight;
                    EvtAtInfo i = e.getValue();
                    int tick = (int)e.getKey().getTime();
                    if (i.lastTick == tick) continue;
                    if (i.lastTick + 20 < tick || i.lastTick > tick && i.lastTick - 24000 + 20 < tick) {
                        i.lastTick = Math2.mod(tick - 10, 24000);
                    }
                    boolean bl = midnight = i.lastTick > tick;
                    if (midnight) {
                        i.lastTick -= 24000;
                    }
                    int startIndex = i.currentIndex;
                    do {
                        int nextTick;
                        EvtAtTime next = i.list.get(i.currentIndex);
                        int n = nextTick = midnight && next.tick > 12000 ? next.tick - 24000 : next.tick;
                        if (i.lastTick >= nextTick || nextTick > tick) break;
                        next.execute(e.getKey());
                        ++i.currentIndex;
                        if (i.currentIndex != i.list.size()) continue;
                        i.currentIndex = 0;
                    } while (i.currentIndex != startIndex);
                    i.lastTick = tick;
                }
            }
        }, 0L, 10L);
    }

    void execute(World w) {
        Trigger t = this.t;
        if (t == null) {
            assert (false);
            return;
        }
        ScheduledEvent e = new ScheduledEvent(w);
        SkriptEventHandler.logEventStart(e);
        SkriptEventHandler.logTriggerEnd(t);
        t.execute(e);
        SkriptEventHandler.logTriggerEnd(t);
        SkriptEventHandler.logEventEnd();
    }

    @Override
    public void register(Trigger t) {
        this.t = t;
        for (World w : this.worlds) {
            EvtAtInfo i = triggers.get(w);
            if (i == null) {
                i = new EvtAtInfo();
                triggers.put(w, i);
                i.lastTick = (int)w.getTime() - 1;
            }
            i.list.add(this);
            Collections.sort(i.list);
        }
        EvtAtTime.registerListener();
    }

    @Override
    public void unregister(Trigger t) {
        assert (t == this.t);
        this.t = null;
        Iterator<EvtAtInfo> iter = triggers.values().iterator();
        while (iter.hasNext()) {
            EvtAtInfo i = iter.next();
            i.list.remove(this);
            if (i.currentIndex >= i.list.size()) {
                --i.currentIndex;
            }
            if (!i.list.isEmpty()) continue;
            iter.remove();
        }
        if (triggers.isEmpty()) {
            this.unregisterAll();
        }
    }

    @Override
    public void unregisterAll() {
        if (taskID != -1) {
            Bukkit.getScheduler().cancelTask(taskID);
        }
        this.t = null;
        taskID = -1;
        triggers.clear();
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "at " + Time.toString(this.tick) + " in worlds " + Classes.toString(this.worlds, true);
    }

    @Override
    public int compareTo(@Nullable EvtAtTime e) {
        return e == null ? this.tick : this.tick - e.tick;
    }

    static {
        Skript.registerEvent("*At Time", EvtAtTime.class, ScheduledEvent.class, "at %time% [in %worlds%]").description("An event that occurs at a given <a href='../classes.html#time'>minecraft time</a> in every world or only in specific worlds.").examples("at 18:00", "at 7am in \"world\"").since("1.3.4");
        triggers = new HashMap();
        taskID = -1;
    }

    private static final class EvtAtInfo {
        int lastTick;
        int currentIndex;
        ArrayList<EvtAtTime> list = new ArrayList();
    }
}

