/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.events.util.PlayerChatEventHandler;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.util.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.plugin.EventExecutor;
import org.eclipse.jdt.annotation.Nullable;

public class EvtChat
extends SelfRegisteringSkriptEvent {
    static final Collection<Trigger> triggers;
    private static boolean registeredExecutor;
    private static final EventExecutor executor;

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "chat";
    }

    @Override
    public void register(Trigger t) {
        triggers.add(t);
        if (!registeredExecutor) {
            PlayerChatEventHandler.registerChatEvent(SkriptConfig.defaultEventPriority.value(), executor, true);
            registeredExecutor = true;
        }
    }

    @Override
    public void unregister(Trigger t) {
        triggers.remove(t);
    }

    @Override
    public void unregisterAll() {
        triggers.clear();
    }

    static {
        Skript.registerEvent("Chat", EvtChat.class, PlayerChatEventHandler.usesAsyncEvent ? AsyncPlayerChatEvent.class : PlayerChatEvent.class, "chat").description("Called whenever a player chats. Use <a href='../expressions.html#ExprChatFormat'>chat format</a> to change message format, use <a href='../expressions.html#ExprChatRecipients'>chat recipients</a> to edit chat recipients.").examples("on chat:", "\tif player has permission \"owner\":", "\t\tset chat format to \"<red>[player]<light gray>: <light red>[message]\"", "\telse if player has permission \"admin\":", "\t\tset chat format to \"<light red>[player]<light gray>: <orange>[message]\"", "\telse: #default message format", "\t\tset chat format to \"<orange>[player]<light gray>: <white>[message]\"").since("1.4.1");
        triggers = new ArrayList<Trigger>();
        registeredExecutor = false;
        executor = new EventExecutor(){

            final void execute(Event e) {
                SkriptEventHandler.logEventStart(e);
                for (Trigger t : triggers) {
                    assert (t != null) : triggers;
                    SkriptEventHandler.logTriggerStart(t);
                    t.execute(e);
                    SkriptEventHandler.logTriggerEnd(t);
                }
                SkriptEventHandler.logEventEnd();
            }

            public void execute(@Nullable Listener l, final @Nullable Event e) throws EventException {
                if (e == null) {
                    return;
                }
                if (!triggers.isEmpty()) {
                    if (e instanceof PlayerChatEvent || !e.isAsynchronous()) {
                        this.execute(e);
                        return;
                    }
                    Task.callSync(new Callable<Void>(){

                        @Override
                        @Nullable
                        public Void call() throws Exception {
                            this.execute(e);
                            return null;
                        }
                    });
                }
            }
        };
    }
}

