/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Silverfish;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.eclipse.jdt.annotation.Nullable;

public class EvtEntityBlockChange
extends SkriptEvent {
    static final ItemType monsterEgg;
    private ChangeEvent event;

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.event = ChangeEvent.values()[matchedPattern];
        return true;
    }

    @Override
    public boolean check(Event e) {
        if (!(e instanceof EntityChangeBlockEvent)) {
            return false;
        }
        return this.event.checker.check((EntityChangeBlockEvent)e);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "" + this.event.name().toLowerCase(Locale.ENGLISH).replace('_', ' ');
    }

    static {
        Skript.registerEvent("Enderman/Sheep/Silverfish/Falling Block", EvtEntityBlockChange.class, EntityChangeBlockEvent.class, ChangeEvent.patterns).description("Called when an enderman places or picks up a block, a sheep eats grass, ", "a silverfish boops into/out of a block or a falling block lands and turns into a block respectively.").examples("on sheep eat:", "\tkill entity", "\tbroadcast \"A sheep stole some grass!\"", "on falling block land:", "\tif event-entity is a falling dirt:", "\t\tcancel event").since("<i>unknown</i>, 2.5.2 (falling block)");
        monsterEgg = Aliases.javaItemType("any spawn egg");
    }

    private static enum ChangeEvent {
        ENDERMAN_PLACE("enderman place", new Checker<EntityChangeBlockEvent>(){

            @Override
            public boolean check(EntityChangeBlockEvent e) {
                return e.getEntity() instanceof Enderman && e.getTo() != Material.AIR;
            }
        }),
        ENDERMAN_PICKUP("enderman pickup", new Checker<EntityChangeBlockEvent>(){

            @Override
            public boolean check(EntityChangeBlockEvent e) {
                return e.getEntity() instanceof Enderman && e.getTo() == Material.AIR;
            }
        }),
        SHEEP_EAT("sheep eat", new Checker<EntityChangeBlockEvent>(){

            @Override
            public boolean check(EntityChangeBlockEvent e) {
                return e.getEntity() instanceof Sheep;
            }
        }),
        SILVERFISH_ENTER("silverfish enter", new Checker<EntityChangeBlockEvent>(){

            @Override
            public boolean check(EntityChangeBlockEvent e) {
                return e.getEntity() instanceof Silverfish && e.getTo() != monsterEgg.getMaterial();
            }
        }),
        SILVERFISH_EXIT("silverfish exit", new Checker<EntityChangeBlockEvent>(){

            @Override
            public boolean check(EntityChangeBlockEvent e) {
                return e.getEntity() instanceof Silverfish && e.getTo() != monsterEgg.getMaterial();
            }
        }),
        FALLING_BLOCK_LANDING("falling block land[ing]", new Checker<EntityChangeBlockEvent>(){

            @Override
            public boolean check(EntityChangeBlockEvent e) {
                return e.getEntity() instanceof FallingBlock;
            }
        });

        private final String pattern;
        final Checker<EntityChangeBlockEvent> checker;
        static String[] patterns;

        private ChangeEvent(String pattern, Checker<EntityChangeBlockEvent> c) {
            this.pattern = pattern;
            this.checker = c;
        }

        static {
            patterns = new String[ChangeEvent.values().length];
            for (int i = 0; i < patterns.length; ++i) {
                ChangeEvent.patterns[i] = ChangeEvent.values()[i].pattern;
            }
        }
    }
}

