/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Alphabetical Sort")
@Description(value={"Sorts given strings in alphabetical order."})
@Examples(value={"set {_list::*} to alphabetically sorted {_strings::*}"})
@Since(value="2.2-dev18b")
public class ExprAlphabetList
extends SimpleExpression<String> {
    private Expression<String> texts;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.texts = exprs[0];
        return true;
    }

    @Nullable
    protected String[] get(Event e) {
        Object[] sorted = (String[])this.texts.getAll(e).clone();
        Arrays.sort(sorted);
        return sorted;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "alphabetically sorted strings: " + this.texts.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprAlphabetList.class, String.class, ExpressionType.COMBINED, "alphabetically sorted %strings%");
    }
}

