/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Bed")
@Description(value={"The bed location of a player, i.e. the spawn point of a player if he ever slept in a bed and the bed still exists and is unobstructed."})
@Examples(value={"bed of player exists:", "\tteleport player the the player's bed", "else:", "\tteleport the player to the world's spawn point"})
@Since(value="2.0")
public class ExprBed
extends SimplePropertyExpression<Player, Location> {
    @Override
    @Nullable
    public Location convert(Player p) {
        return p.getBedSpawnLocation();
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{Location.class};
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            for (Player p : (Player[])this.getExpr().getArray(e)) {
                p.setBedSpawnLocation(null, true);
            }
        } else {
            Location l = (Location)delta[0];
            for (Player p : (Player[])this.getExpr().getArray(e)) {
                p.setBedSpawnLocation(l, true);
            }
        }
    }

    @Override
    protected String getPropertyName() {
        return "bed";
    }

    @Override
    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    static {
        ExprBed.register(ExprBed.class, Location.class, "bed[s] [location[s]]", "players");
    }
}

