/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Block Data")
@Description(value={"Get the <a href='classes.html#blockdata'>block data</a> associated with a block. This data can also be used to set blocks."})
@Examples(value={"set {data} to block data of target block", "set block at player to {data}", "set block data of target block to oak_stairs[facing=south;waterlogged=true]"})
@RequiredPlugins(value={"Minecraft 1.13+"})
@Since(value="2.5, 2.5.2 (set)")
public class ExprBlockData
extends SimplePropertyExpression<Block, BlockData> {
    @Override
    @Nullable
    public BlockData convert(Block block) {
        return block.getBlockData();
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return CollectionUtils.array(BlockData.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            return;
        }
        BlockData blockData = (BlockData)delta[0];
        for (Block block : (Block[])this.getExpr().getArray(e)) {
            block.setBlockData(blockData);
        }
    }

    @Override
    protected String getPropertyName() {
        return "block data";
    }

    @Override
    public Class<? extends BlockData> getReturnType() {
        return BlockData.class;
    }

    static {
        if (Skript.classExists("org.bukkit.block.data.BlockData")) {
            ExprBlockData.register(ExprBlockData.class, BlockData.class, "block[ ]data", "blocks");
        }
    }
}

