/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.AABB;
import ch.njol.skript.util.BlockLineIterator;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.iterator.ArrayIterator;
import ch.njol.util.coll.iterator.IteratorIterable;
import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Blocks")
@Description(value={"Blocks relative to other blocks or between other blocks. Can be used to get blocks relative to other blocks or for looping.", "Blocks from/to and between will return a straight line whereas blocks within will return a cuboid."})
@Examples(value={"loop blocks above the player:", "loop blocks between the block below the player and the targeted block:", "set the blocks below the player, the victim and the targeted block to air", "set all blocks within {loc1} and {loc2} to stone", "set all blocks within chunk at player to air"})
@Since(value="1.0, 2.5.1 (within/cuboid/chunk)")
public class ExprBlocks
extends SimpleExpression<Block> {
    private int pattern;
    private Expression<?> from;
    @Nullable
    private Expression<Location> end;
    @Nullable
    private Expression<Direction> direction;
    @Nullable
    private Expression<Chunk> chunk;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.pattern = matchedPattern;
        switch (matchedPattern) {
            case 0: {
                this.direction = exprs[0];
                this.from = exprs[1];
                break;
            }
            case 1: {
                this.from = exprs[0];
                this.direction = exprs[1];
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.from = exprs[0];
                this.end = exprs[1];
                break;
            }
            case 5: {
                this.chunk = exprs[0];
                break;
            }
            default: {
                assert (false) : matchedPattern;
                return false;
            }
        }
        return true;
    }

    @Nullable
    protected Block[] get(Event e) {
        Expression<Direction> direction = this.direction;
        if (direction != null && !this.from.isSingle()) {
            Location[] ls = (Location[])this.from.getArray(e);
            Direction d = direction.getSingle(e);
            if (ls.length == 0 || d == null) {
                return new Block[0];
            }
            Block[] bs = new Block[ls.length];
            for (int i = 0; i < ls.length; ++i) {
                bs[i] = d.getRelative(ls[i]).getBlock();
            }
            return bs;
        }
        ArrayList<Block> r = new ArrayList<Block>();
        Iterator<Block> iter = this.iterator(e);
        if (iter == null) {
            return new Block[0];
        }
        for (Block b : new IteratorIterable<Block>(iter)) {
            r.add(b);
        }
        return r.toArray(new Block[r.size()]);
    }

    @Override
    @Nullable
    public Iterator<Block> iterator(Event e) {
        block13: {
            try {
                Expression<Direction> direction = this.direction;
                if (this.chunk != null) {
                    Chunk chunk = this.chunk.getSingle(e);
                    if (chunk != null) {
                        return new AABB(chunk).iterator();
                    }
                    break block13;
                }
                if (direction != null) {
                    if (!this.from.isSingle()) {
                        return new ArrayIterator<Block>(this.get(e));
                    }
                    Object o = this.from.getSingle(e);
                    if (o == null) {
                        return null;
                    }
                    Location l = o instanceof Location ? (Location)o : ((Block)o).getLocation().add(0.5, 0.5, 0.5);
                    Direction d = direction.getSingle(e);
                    if (d == null) {
                        return null;
                    }
                    return new BlockLineIterator(l, o != l ? d.getDirection((Block)o) : d.getDirection(l), (double)SkriptConfig.maxTargetBlockDistance.value().intValue());
                }
                Location loc = (Location)this.from.getSingle(e);
                if (loc == null) {
                    return null;
                }
                assert (this.end != null);
                Location loc2 = this.end.getSingle(e);
                if (loc2 == null || loc2.getWorld() != loc.getWorld()) {
                    return null;
                }
                if (this.pattern == 4) {
                    return new AABB(loc, loc2).iterator();
                }
                return new BlockLineIterator(loc.getBlock(), loc2.getBlock());
            }
            catch (IllegalStateException ex) {
                if (ex.getMessage().equals("Start block missed in BlockIterator")) {
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    @Override
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        Expression<Location> end = this.end;
        if (this.chunk != null) {
            return "blocks within chunk " + this.chunk.toString(e, debug);
        }
        if (this.pattern == 4) {
            assert (end != null);
            return "blocks within " + this.from.toString(e, debug) + " and " + end.toString(e, debug);
        }
        if (end != null) {
            return "blocks from " + this.from.toString(e, debug) + " to " + end.toString(e, debug);
        }
        Expression<Direction> direction = this.direction;
        assert (direction != null);
        return "block" + (this.isSingle() ? "" : "s") + " " + direction.toString(e, debug) + " " + this.from.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprBlocks.class, Block.class, ExpressionType.COMBINED, "[(all [[of] the]|the)] blocks %direction% [%locations%]", "[(all [[of] the]|the)] blocks from %location% [on] %direction%", "[(all [[of] the]|the)] blocks from %location% to %location%", "[(all [[of] the]|the)] blocks between %location% and %location%", "[(all [[of] the]|the)] blocks within %location% and %location%", "[(all [[of] the]|the)] blocks (in|within) %chunk%");
    }
}

