/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.ItemUtils;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Data/Damage Value")
@Description(value={"The data/damage value of an item/block. Data values of blocks are only supported on 1.12.2 and below.", "You usually don't need this expression as you can check and set items with aliases easily, ", "but this expression can e.g. be used to \"add 1 to data of &lt;item&gt;\", e.g. for cycling through all wool colours."})
@Examples(value={"set damage value of player's tool to 10", "set data value of target block of player to 3", "add 1 to the data value of the clicked block", "reset data value of block at player"})
@Since(value="1.2")
public class ExprDurability
extends SimplePropertyExpression<Object, Number> {
    private static final boolean LEGACY_BLOCK = !Skript.isRunningMinecraft(1, 13);

    @Override
    @Nullable
    public Number convert(Object o) {
        if (o instanceof Slot) {
            ItemStack i = ((Slot)o).getItem();
            return i == null ? null : Integer.valueOf(ItemUtils.getDamage(i));
        }
        if (o instanceof ItemType) {
            ItemStack item = ((ItemType)o).getRandom();
            return item != null ? Integer.valueOf(ItemUtils.getDamage(item)) : null;
        }
        if (LEGACY_BLOCK && o instanceof Block) {
            return ((Block)o).getData();
        }
        return null;
    }

    @Override
    public String getPropertyName() {
        return "data";
    }

    @Override
    public Class<Number> getReturnType() {
        return Number.class;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case ADD: 
            case SET: 
            case RESET: 
            case REMOVE: 
            case DELETE: {
                return CollectionUtils.array(Number.class);
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        F[] os;
        int a = delta == null ? 0 : ((Number)delta[0]).intValue();
        for (Object o : os = this.getExpr().getArray(e)) {
            ItemStack itemStack = null;
            Block block = null;
            if (o instanceof ItemType) {
                itemStack = ((ItemType)o).getRandom();
            } else if (o instanceof Slot) {
                itemStack = ((Slot)o).getItem();
            } else if (LEGACY_BLOCK) {
                block = (Block)o;
            } else {
                return;
            }
            int changeValue = itemStack != null ? ItemUtils.getDamage(itemStack) : (block != null ? (int)block.getData() : 0);
            switch (mode) {
                case REMOVE: {
                    a = -a;
                }
                case ADD: {
                    changeValue += a;
                    break;
                }
                case SET: {
                    changeValue = a;
                    break;
                }
                case RESET: 
                case DELETE: {
                    changeValue = 0;
                    break;
                }
                case REMOVE_ALL: {
                    assert (false);
                    break;
                }
            }
            if (o instanceof ItemType && itemStack != null) {
                ItemUtils.setDamage(itemStack, changeValue);
                ((ItemType)o).setTo(new ItemType(itemStack));
                continue;
            }
            if (o instanceof Slot) {
                ItemUtils.setDamage(itemStack, changeValue);
                ((Slot)o).setItem(itemStack);
                continue;
            }
            BlockState blockState = ((Block)o).getState();
            try {
                blockState.setRawData((byte)Math.max(0, changeValue));
                blockState.update();
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
    }

    static {
        ExprDurability.register(ExprDurability.class, Number.class, "((data|damage)[s] [value[s]]|durabilit(y|ies))", "itemtypes/blocks/slots");
    }
}

