/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.lang.reflect.Array;
import java.util.Iterator;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Element of")
@Description(value={"The first, last or a random element of a set, e.g. a list variable.", "See also: <a href='#ExprRandom'>random</a>"})
@Examples(value={"give a random element out of {free items::*} to the player"})
@Since(value="2.0")
public class ExprElement
extends SimpleExpression<Object> {
    private int element;
    private Expression<?> expr;
    @Nullable
    private Expression<Number> number;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.expr = LiteralUtils.defendExpression(exprs[1]);
        this.number = exprs[0];
        this.element = parseResult.mark;
        return LiteralUtils.canInitSafely(this.expr);
    }

    @Override
    @Nullable
    protected Object[] get(Event e) {
        ?[] os;
        Object o;
        if (this.element == -1) {
            Iterator<?> iter = this.expr.iterator(e);
            if (iter == null || !iter.hasNext()) {
                return null;
            }
            o = iter.next();
        } else if (this.element == 1) {
            os = this.expr.getArray(e);
            if (os.length == 0) {
                return null;
            }
            o = os[os.length - 1];
        } else if (this.element == 2) {
            os = this.expr.getArray(e);
            Number number = this.number.getSingle(e);
            if (number == null || number.intValue() - 1 >= os.length || number.intValue() - 1 < 0) {
                return null;
            }
            o = os[number.intValue() - 1];
        } else {
            os = this.expr.getArray(e);
            if (os.length == 0) {
                return null;
            }
            o = CollectionUtils.getRandom(os);
        }
        Object[] r = (Object[])Array.newInstance(this.getReturnType(), 1);
        r[0] = o;
        return r;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.expr.getReturnType();
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return (this.element == 0 ? "a " : "the ") + (this.element == -1 ? "first" : (this.element == 1 ? "last" : "random")) + " element of " + this.expr.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprElement.class, Object.class, ExpressionType.PROPERTY, "(-1\u00a6[the] first|1\u00a6[the] last|0\u00a6[a] random|2\u00a6%-number%(st|nd|rd|th)) element [out] of %objects%");
    }
}

