/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Entity Owner")
@Description(value={"The owner of a tameable entity, such as a horse or wolf."})
@Examples(value={"set owner of target entity to player", "delete owner of target entity", "set {_t} to uuid of tamer of target entity"})
@Since(value="2.5")
public class ExprEntityTamer
extends SimplePropertyExpression<LivingEntity, OfflinePlayer> {
    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return CollectionUtils.array(OfflinePlayer.class);
        }
        return null;
    }

    @Override
    @Nullable
    public OfflinePlayer convert(LivingEntity entity) {
        Tameable t;
        if (entity instanceof Tameable && (t = (Tameable)entity).isTamed()) {
            return (OfflinePlayer)t.getOwner();
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        OfflinePlayer player = delta == null ? null : (OfflinePlayer)delta[0];
        switch (mode) {
            case SET: {
                for (LivingEntity entity : (LivingEntity[])this.getExpr().getAll(e)) {
                    if (!(entity instanceof Tameable)) continue;
                    ((Tameable)entity).setOwner((AnimalTamer)player);
                }
                break;
            }
            case DELETE: 
            case RESET: {
                for (LivingEntity entity : (LivingEntity[])this.getExpr().getAll(e)) {
                    if (!(entity instanceof Tameable)) continue;
                    ((Tameable)entity).setOwner(null);
                }
                break;
            }
        }
    }

    @Override
    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    @Override
    protected String getPropertyName() {
        return "entity owner";
    }

    @Override
    public String toString(@Nullable Event e, boolean d) {
        return "owner of " + this.getExpr().toString(e, d);
    }

    static {
        ExprEntityTamer.register(ExprEntityTamer.class, OfflinePlayer.class, "(owner|tamer)", "livingentities");
    }
}

