/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.iterator.ArrayIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Filter")
@Description(value={"Filters a list based on a condition. For example, if you ran 'broadcast \"something\" and \"something else\" where [string input is \"something\"]', only \"something\" would be broadcast as it is the only string that matched the condition."})
@Examples(value={"send \"congrats on being staff!\" to all players where [player input has permission \"staff\"]"})
@Since(value="2.2-dev36")
public class ExprFilter
extends SimpleExpression<Object> {
    @Nullable
    private static ExprFilter parsing;
    private Object current;
    private List<ExprInput<?>> children = new ArrayList();
    private Condition condition;
    private String rawCond;
    private Expression<Object> objects;

    @Nullable
    public static ExprFilter getParsing() {
        return parsing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        try {
            parsing = this;
            this.objects = LiteralUtils.defendExpression(exprs[0]);
            this.rawCond = parseResult.regexes.get(0).group();
            this.condition = Condition.parse(this.rawCond, "Can't understand this condition: " + this.rawCond);
        }
        finally {
            parsing = null;
        }
        return this.condition != null && LiteralUtils.canInitSafely(this.objects);
    }

    @Override
    @NonNull
    public Iterator<?> iterator(Event e) {
        try {
            UnmodifiableIterator unmodifiableIterator = Iterators.filter(new ArrayIterator<Object>(this.objects.getArray(e)), object -> {
                this.current = object;
                return this.condition.check(e);
            });
            return unmodifiableIterator;
        }
        finally {
            this.current = null;
        }
    }

    @Override
    protected Object[] get(Event e) {
        try {
            return Converters.convertStrictly(Iterators.toArray(this.iterator(e), Object.class), this.getReturnType());
        }
        catch (ClassCastException e1) {
            return null;
        }
    }

    public Object getCurrent() {
        return this.current;
    }

    private void addChild(ExprInput<?> child) {
        this.children.add(child);
    }

    private void removeChild(ExprInput<?> child) {
        this.children.remove(child);
    }

    @Override
    public Class<?> getReturnType() {
        return this.objects.getReturnType();
    }

    @Override
    public boolean isSingle() {
        return this.objects.isSingle();
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.format("%s where [%s]", this.objects.toString(e, debug), this.rawCond);
    }

    @Override
    public boolean isLoopOf(String s) {
        for (ExprInput<?> child : this.children) {
            if (((ExprInput)child).getClassInfo() == null || ((ExprInput)child).getClassInfo().getUserInputPatterns() == null) continue;
            for (Pattern pattern : ((ExprInput)child).getClassInfo().getUserInputPatterns()) {
                if (!pattern.matcher(s).matches()) continue;
                return true;
            }
        }
        return this.objects.isLoopOf(s);
    }

    static {
        Skript.registerExpression(ExprFilter.class, Object.class, ExpressionType.COMBINED, "%objects% (where|that match) \\[<.+>\\]");
    }

    @Name(value="Filter Input")
    @Description(value={"Represents the input in a filter expression. For example, if you ran 'broadcast \"something\" and \"something else\" where [input is \"something\"]the condition would be checked twice, using \"something\" and \"something else\" as the inputs."})
    @Examples(value={"send \"congrats on being staff!\" to all players where [input has permission \"staff\"]"})
    @Since(value="2.2-dev36")
    public static class ExprInput<T>
    extends SimpleExpression<T> {
        @Nullable
        private final ExprInput<?> source;
        private final Class<? extends T>[] types;
        private final Class<T> superType;
        private ExprFilter parent;
        @Nullable
        private ClassInfo<?> inputType;

        public ExprInput() {
            this(null, Object.class);
        }

        public ExprInput(@Nullable ExprInput<?> source, Class<? extends T> ... types) {
            this.source = source;
            if (source != null) {
                this.parent = source.parent;
                this.inputType = source.inputType;
                this.parent.removeChild(source);
                this.parent.addChild(this);
            }
            this.types = types;
            this.superType = Utils.getSuperType(types);
        }

        @Override
        public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
            this.parent = ExprFilter.getParsing();
            if (this.parent == null) {
                return false;
            }
            this.parent.addChild(this);
            this.inputType = matchedPattern == 0 ? null : (ClassInfo)((Literal)exprs[0]).getSingle();
            return true;
        }

        @Override
        protected T[] get(Event e) {
            Object current = this.parent.getCurrent();
            if (this.inputType != null && !this.inputType.getC().isInstance(current)) {
                return null;
            }
            try {
                return Converters.convertArray(new Object[]{current}, this.types, this.superType);
            }
            catch (ClassCastException e1) {
                return (Object[])Array.newInstance(this.superType, 0);
            }
        }

        public void setParent(ExprFilter parent) {
            this.parent = parent;
        }

        @Override
        public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
            return new ExprInput<R>(this, to);
        }

        @Override
        public Expression<?> getSource() {
            return this.source == null ? this : this.source;
        }

        @Override
        public Class<? extends T> getReturnType() {
            return this.superType;
        }

        @Nullable
        private ClassInfo<?> getClassInfo() {
            return this.inputType;
        }

        @Override
        public boolean isSingle() {
            return true;
        }

        @Override
        public String toString(Event e, boolean debug) {
            return this.inputType == null ? "input" : this.inputType.getCodeName() + " input";
        }

        static {
            Skript.registerExpression(ExprInput.class, Object.class, ExpressionType.COMBINED, "input", "%*classinfo% input");
        }
    }
}

