/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.GameruleValue;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Gamerule Value")
@Description(value={"The gamerule value of a world."})
@Examples(value={"set the gamerule commandBlockOutput of world \"world\" to false"})
@Since(value="2.5")
@RequiredPlugins(value={"Minecraft 1.13+"})
public class ExprGameRule
extends SimpleExpression<GameruleValue> {
    private Expression<GameRule> gamerule;
    private Expression<World> world;
    static final /* synthetic */ boolean $assertionsDisabled;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.gamerule = exprs[0];
        this.world = exprs[1];
        return true;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return CollectionUtils.array(Boolean.class, Number.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (!$assertionsDisabled && delta == null) {
            throw new AssertionError();
        }
        if (mode == Changer.ChangeMode.SET) {
            GameRule bukkitGamerule = this.gamerule.getSingle(e);
            if (bukkitGamerule == null) {
                return;
            }
            for (World gameruleWorld : this.world.getArray(e)) {
                gameruleWorld.setGameRule(bukkitGamerule, delta[0]);
            }
        }
    }

    @Nullable
    protected GameruleValue[] get(Event e) {
        GameRule bukkitGamerule = this.gamerule.getSingle(e);
        if (bukkitGamerule == null) {
            return null;
        }
        World[] gameruleWorlds = this.world.getArray(e);
        GameruleValue[] gameruleValues = new GameruleValue[gameruleWorlds.length];
        int index = 0;
        for (World gameruleWorld : gameruleWorlds) {
            Object gameruleValue = gameruleWorld.getGameRuleValue(bukkitGamerule);
            if (!$assertionsDisabled && gameruleValue == null) {
                throw new AssertionError();
            }
            gameruleValues[index++] = new GameruleValue<Object>(gameruleValue);
        }
        return gameruleValues;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends GameruleValue> getReturnType() {
        return GameruleValue.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the gamerule value of " + this.gamerule.toString(e, debug) + " for world " + this.world.toString(e, debug);
    }

    static {
        boolean bl = $assertionsDisabled = !ExprGameRule.class.desiredAssertionStatus();
        if (Skript.classExists("org.bukkit.GameRule")) {
            Skript.registerExpression(ExprGameRule.class, GameruleValue.class, ExpressionType.COMBINED, "[the] gamerule %gamerule% of %worlds%");
        }
    }
}

