/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Heal Reason")
@Description(value={"The <a href='../classes.html#healreason'>heal reason</a> of a heal event. Please click on the link for more information."})
@Examples(value={"on heal:", "\tif heal reason = satiated:", "\t\tsend \"You ate enough food and gained health back!\" to player"})
@Since(value="2.5")
public class ExprHealReason
extends SimpleExpression<EntityRegainHealthEvent.RegainReason> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent((Class<? extends Event>)EntityRegainHealthEvent.class)) {
            Skript.error("Heal reason can only be used in an on heal event", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    @Nullable
    protected EntityRegainHealthEvent.RegainReason[] get(Event e) {
        return new EntityRegainHealthEvent.RegainReason[]{((EntityRegainHealthEvent)e).getRegainReason()};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends EntityRegainHealthEvent.RegainReason> getReturnType() {
        return EntityRegainHealthEvent.RegainReason.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "heal reason";
    }

    static {
        Skript.registerExpression(ExprHealReason.class, EntityRegainHealthEvent.RegainReason.class, ExpressionType.SIMPLE, "(regen|health regain|heal) (reason|cause)");
    }
}

