/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.ExpressionType;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Highest Solid Block")
@Description(value={"Returns the highest solid block at the x and z coordinates of the world of a given location."})
@Examples(value={"highest block at location of arg-player"})
@Since(value="2.2-dev34")
public class ExprHighestSolidBlock
extends SimplePropertyExpression<Location, Block> {
    @Override
    protected String getPropertyName() {
        return "highest [(solid|non-air)] block";
    }

    @Override
    @Nullable
    public Block convert(Location location) {
        return location.getWorld().getHighestBlockAt(location);
    }

    @Override
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    static {
        Skript.registerExpression(ExprHighestSolidBlock.class, Block.class, ExpressionType.PROPERTY, "highest [(solid|non-air)] block at %locations%");
    }
}

