/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.ExprAttacker;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Last Attacker")
@Description(value={"The last block or entity that attacked an entity."})
@Examples(value={"send \"%last attacker of event-entity%\""})
@Since(value="2.5.1")
public class ExprLastAttacker
extends SimplePropertyExpression<Entity, Object> {
    @Nullable
    private ExprAttacker attackerExpr;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.attackerExpr = new ExprAttacker();
        this.setExpr(exprs[0]);
        return true;
    }

    @Override
    @Nullable
    public Object convert(Entity entity) {
        return this.attackerExpr.get((Event)entity.getLastDamageCause())[0];
    }

    @Override
    public Class<?> getReturnType() {
        return Object.class;
    }

    @Override
    protected String getPropertyName() {
        return "last attacker";
    }

    static {
        ExprLastAttacker.register(ExprLastAttacker.class, Object.class, "last attacker", "entity");
    }
}

