/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.ExprDamage;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Last Damage")
@Description(value={"The last damage that was done to an entity. Note that changing it doesn't deal more/less damage."})
@Examples(value={"set last damage of event-entity to 2"})
@Since(value="2.5.1")
public class ExprLastDamage
extends SimplePropertyExpression<LivingEntity, Number> {
    @Nullable
    private ExprDamage damageExpr;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.damageExpr = new ExprDamage();
        return true;
    }

    @Override
    @Nullable
    public Number convert(LivingEntity livingEntity) {
        return this.damageExpr.get((Event)livingEntity.getLastDamageCause())[0];
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case ADD: 
            case SET: 
            case REMOVE: {
                return CollectionUtils.array(Number.class);
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null) {
            switch (mode) {
                case SET: {
                    for (LivingEntity entity : (LivingEntity[])this.getExpr().getArray(e)) {
                        entity.setLastDamage((double)((Long)delta[0]).longValue());
                    }
                    break;
                }
                case REMOVE: {
                    delta[0] = (Long)delta[0] * -1L;
                }
                case ADD: {
                    for (LivingEntity entity : (LivingEntity[])this.getExpr().getArray(e)) {
                        entity.setLastDamage((double)((Long)delta[0]).longValue() + entity.getLastDamage());
                    }
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    protected String getPropertyName() {
        return "last damage";
    }

    static {
        ExprLastDamage.register(ExprLastDamage.class, Number.class, "last damage", "livingentities");
    }
}

