/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Named Item/Inventory")
@Description(value={"Directly names an item/inventory, useful for defining a named item/inventory in a script. If you want to (re)name existing items/inventories you can either use this expression or use <code>set <a href='#ExprName'>name of &lt;item/inventory&gt;</a> to &lt;text&gt;</code>."})
@Examples(value={"give a diamond sword of sharpness 100 named \"<gold>Excalibur\" to the player", "set tool of player to the player's tool named \"<gold>Wand\"", "set the name of the player's tool to \"<gold>Wand\"", "open hopper inventory named \"Magic Hopper\" to player"})
@Since(value="2.0, 2.2-dev34 (inventories)")
public class ExprNamed
extends PropertyExpression<Object, Object> {
    private Expression<String> name;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.name = exprs[1];
        return true;
    }

    @Override
    protected Object[] get(Event e, Object[] source) {
        final String name = this.name.getSingle(e);
        if (name == null) {
            return this.get(source, obj -> obj);
        }
        return this.get(source, new Getter<Object, Object>(){

            @Override
            @Nullable
            public Object get(Object obj) {
                if (obj instanceof InventoryType) {
                    return Bukkit.createInventory(null, (InventoryType)((InventoryType)obj), (String)name);
                }
                if (obj instanceof ItemStack) {
                    ItemStack stack = (ItemStack)obj;
                    ItemMeta meta = (stack = stack.clone()).getItemMeta();
                    if (meta != null) {
                        meta.setDisplayName(name);
                        stack.setItemMeta(meta);
                    }
                    return new ItemType(stack);
                }
                ItemType item = (ItemType)obj;
                item = item.clone();
                ItemMeta meta = item.getItemMeta();
                meta.setDisplayName(name);
                item.setItemMeta(meta);
                return item;
            }
        });
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.getExpr().getReturnType() == InventoryType.class ? Inventory.class : ItemType.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.getExpr().toString(e, debug) + " named " + this.name;
    }

    static {
        Skript.registerExpression(ExprNamed.class, Object.class, ExpressionType.PROPERTY, "%itemtype/inventorytype% (named|with name[s]) %string%");
    }
}

