/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Iterator;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Number of Characters")
@Description(value={"The number of uppercase, lowercase, or digit characters in a string."})
@Examples(value={"#Simple Chat Filter", "on chat:", "\tif number of uppercase chars in message / length of message > 0.5", "\t\tcancel event", "\t\tsend \"<red>Your message has to many caps!\" to player"})
@Since(value="2.5")
public class ExprNumberOfCharacters
extends SimpleExpression<Number> {
    private int pattern = 0;
    private Expression<String> expr;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        this.expr = exprs[0];
        return true;
    }

    @Nullable
    protected Number[] get(Event e) {
        String str = this.expr.getSingle(e);
        int size = 0;
        if (this.pattern == 0) {
            Iterator iterator = ((Iterable)str.codePoints()::iterator).iterator();
            while (iterator.hasNext()) {
                int c = (Integer)iterator.next();
                if (!Character.isUpperCase(c)) continue;
                ++size;
            }
        } else if (this.pattern == 1) {
            Iterator iterator = ((Iterable)str.codePoints()::iterator).iterator();
            while (iterator.hasNext()) {
                int c = (Integer)iterator.next();
                if (!Character.isLowerCase(c)) continue;
                ++size;
            }
        } else {
            Iterator iterator = ((Iterable)str.codePoints()::iterator).iterator();
            while (iterator.hasNext()) {
                int c = (Integer)iterator.next();
                if (!Character.isDigit(c)) continue;
                ++size;
            }
        }
        return new Number[]{size};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (this.pattern == 0) {
            return "number of uppercase characters";
        }
        if (this.pattern == 1) {
            return "number of lowercase characters";
        }
        return "number of digits";
    }

    static {
        Skript.registerExpression(ExprNumberOfCharacters.class, Number.class, ExpressionType.SIMPLE, "number of upper[ ]case char(acters|s) in %string%", "number of lower[ ]case char(acters|s) in %string%", "number of digit char(acters|s) in %string%");
    }
}

