/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Kleenean;
import ch.njol.util.NonNullPair;
import java.lang.reflect.Array;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Parse")
@Description(value={"Parses text as a given type, or as a given pattern.", "This expression can be used in two different ways: One which parses the entire text as a single instance of a type, e.g. as a number, and one that parses the text according to a pattern.", "If the given text could not be parsed, this expression will return nothing and the <a href='#ExprParseError'>parse error</a> will be set if some information is available.", "Some notes about parsing with a pattern:", "- The pattern must be a <a href='../patterns/'>Skript pattern</a>, e.g. percent signs are used to define where to parse which types, e.g. put a %number% or %items% in the pattern if you expect a number or some items there.", "- You <i>have to</i> save the expression's value in a list variable, e.g. <code>set {parsed::*} to message parsed as \"...\"</code>.", "- The list variable will contain the parsed values from all %types% in the pattern in order. If a type was plural, e.g. %items%, the variable's value at the respective index will be a list variable, e.g. the values will be stored in {parsed::1::*}, not {parsed::1}."})
@Examples(value={"set {var} to line 1 parsed as number", "on chat:", "\tset {var::*} to message parsed as \"buying %items% for %money%\"", "\tif parse error is set:", "\t\tmessage \"%parse error%\"", "\telse if {var::*} is set:", "\t\tcancel event", "\t\tremove {var::2} from the player's balance", "\t\tgive {var::1::*} to the player"})
@Since(value="2.0")
public class ExprParse
extends SimpleExpression<Object> {
    @Nullable
    static String lastError;
    private Expression<String> text;
    @Nullable
    private String pattern;
    @Nullable
    private boolean[] plurals;
    @Nullable
    private ClassInfo<?> c;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.text = exprs[0];
        if (exprs[1] == null) {
            String pattern = "" + parseResult.regexes.get(0).group();
            if (!VariableString.isQuotedCorrectly(pattern, false)) {
                Skript.error("Invalid amount and/or placement of double quotes in '" + pattern + "'", ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
            StringBuilder b = new StringBuilder(pattern.length());
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                if (c == '\\') {
                    b.append(c);
                    b.append(pattern.charAt(i + 1));
                    ++i;
                    continue;
                }
                if (c == '\u00a6') {
                    b.append("\\\u00a6");
                    continue;
                }
                b.append(c);
            }
            pattern = "" + b.toString();
            NonNullPair<String, boolean[]> p = SkriptParser.validatePattern(pattern);
            if (p == null) {
                return false;
            }
            this.pattern = p.getFirst();
            this.plurals = p.getSecond();
        } else {
            this.c = (ClassInfo)((Literal)exprs[1]).getSingle();
            if (this.c.getC() == String.class) {
                Skript.error("Parsing as text is useless as only things that are already text may be parsed");
                return false;
            }
            Parser<?> p = this.c.getParser();
            if (p == null || !p.canParse(ParseContext.COMMAND)) {
                Skript.error("Text cannot be parsed as " + this.c.getName().withIndefiniteArticle(), ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Object[] get(Event e) {
        String t = this.text.getSingle(e);
        if (t == null) {
            return null;
        }
        ParseLogHandler h = SkriptLogger.startParseLogHandler();
        try {
            if (this.c != null) {
                Parser<?> p = this.c.getParser();
                assert (p != null);
                Object o = p.parse(t, ParseContext.COMMAND);
                if (o != null) {
                    Object[] one = (Object[])Array.newInstance(this.c.getC(), 1);
                    one[0] = o;
                    Object[] objectArray = one;
                    return objectArray;
                }
            } else {
                assert (this.pattern != null && this.plurals != null);
                SkriptParser.ParseResult r = SkriptParser.parse(t, this.pattern);
                if (r != null) {
                    assert (this.plurals.length == r.exprs.length);
                    int resultCount = 0;
                    for (int i = 0; i < r.exprs.length; ++i) {
                        if (r.exprs[i] == null) continue;
                        ++resultCount;
                    }
                    Object[] os = new Object[resultCount];
                    int slot = 0;
                    for (int i = 0; i < r.exprs.length; ++i) {
                        if (r.exprs[i] == null) continue;
                        os[slot++] = this.plurals[i] ? r.exprs[i].getArray(null) : r.exprs[i].getSingle(null);
                    }
                    Object[] objectArray = os;
                    return objectArray;
                }
            }
            LogEntry err = h.getError();
            lastError = err != null ? err.getMessage() : null;
            Object[] objectArray = null;
            return objectArray;
        }
        finally {
            h.clear();
            h.printLog();
        }
    }

    @Override
    public boolean isSingle() {
        return this.pattern == null;
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.c != null ? this.c.getC() : Object[].class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.text.toString(e, debug) + " parsed as " + (this.c != null ? this.c.toString(4) : this.pattern);
    }

    static {
        Skript.registerExpression(ExprParse.class, Object.class, ExpressionType.COMBINED, "%string% parsed as (%-*classinfo%|\"<.*>\")");
        lastError = null;
    }
}

