/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="View Distance")
@Description(value={"The view distance of a player. Can be changed."})
@Examples(value={"set view distance of player to 10", "set {_view} to view distance of player", "reset view distance of all players", "add 2 to view distance of player"})
@RequiredPlugins(value={"Paper 1.9-1.13.2"})
@Since(value="2.4")
public class ExprPlayerViewDistance
extends PropertyExpression<Player, Number> {
    static final /* synthetic */ boolean $assertionsDisabled;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Number[] get(Event e, Player[] source) {
        return this.get(source, new Getter<Integer, Player>(){

            @Override
            public Integer get(Player arg) {
                return arg.getViewDistance();
            }
        });
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case DELETE: 
            case SET: 
            case ADD: 
            case REMOVE: 
            case RESET: {
                return CollectionUtils.array(Number.class);
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int distance = delta == null ? 0 : ((Number)delta[0]).intValue();
        switch (mode) {
            case DELETE: 
            case SET: {
                for (Player player : (Player[])this.getExpr().getArray(e)) {
                    player.setViewDistance(distance);
                }
                break;
            }
            case ADD: {
                for (Player player : (Player[])this.getExpr().getArray(e)) {
                    player.setViewDistance(player.getViewDistance() + distance);
                }
                break;
            }
            case REMOVE: {
                for (Player player : (Player[])this.getExpr().getArray(e)) {
                    player.setViewDistance(player.getViewDistance() - distance);
                }
                break;
            }
            case RESET: {
                for (Player player : (Player[])this.getExpr().getArray(e)) {
                    player.setViewDistance(Bukkit.getServer().getViewDistance());
                }
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the view distance of " + this.getExpr().toString(e, debug);
    }

    static {
        boolean bl = $assertionsDisabled = !ExprPlayerViewDistance.class.desiredAssertionStatus();
        if (Skript.methodExists(Player.class, "getViewDistance", new Class[0]) && !Skript.isRunningMinecraft(1, 14)) {
            ExprPlayerViewDistance.register(ExprPlayerViewDistance.class, Number.class, "view distance[s]", "players");
        }
    }
}

