/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.WeatherType;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Player Weather")
@Description(value={"The weather for a player."})
@Examples(value={"set weather of arg-player to rainy", "reset player's weather", "if arg-player's weather is rainy"})
@Since(value="2.2-dev34")
public class ExprPlayerWeather
extends SimplePropertyExpression<Player, WeatherType> {
    @Override
    protected String getPropertyName() {
        return "weather";
    }

    @Override
    @Nullable
    public WeatherType convert(Player player) {
        return WeatherType.fromPlayer(player);
    }

    @Override
    public Class<WeatherType> getReturnType() {
        return WeatherType.class;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.SET) {
            return CollectionUtils.array(WeatherType.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            for (Player p : (Player[])this.getExpr().getArray(e)) {
                p.resetPlayerWeather();
            }
        } else {
            WeatherType type = (WeatherType)((Object)delta[0]);
            for (Player p : (Player[])this.getExpr().getArray(e)) {
                type.setWeather(p);
            }
        }
    }

    static {
        ExprPlayerWeather.register(ExprPlayerWeather.class, WeatherType.class, "[(client|custom)] weather", "players");
    }
}

