/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.PotionEffectUtils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Potion Effects")
@Description(value={"Represents the active potion effects of entities and itemtypes.", "You can clear all potion effects of an entity/itemtype and add/remove a potion effect/type to/from an entity/itemtype.", "Do note you will not be able to clear the base potion effects of a potion item. In that case, just set the item to a water bottle.", "When adding a potion effect type (rather than a potion effect), it will default to 15 seconds with tier 1."})
@Examples(value={"set {_p::*} to active potion effects of player", "clear all the potion effects of player", "clear all the potion effects of player's tool", "add potion effects of player to potion effects of player's tool", "add speed to potion effects of target entity", "remove speed and night vision from potion effects of player"})
@Since(value="2.5.2")
public class ExprPotionEffects
extends SimpleExpression<PotionEffect> {
    private Expression<Object> objects;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.objects = exprs[0];
        return true;
    }

    @Nullable
    protected PotionEffect[] get(Event e) {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (Object object : this.objects.getArray(e)) {
            if (object instanceof LivingEntity) {
                effects.addAll(((LivingEntity)object).getActivePotionEffects());
                continue;
            }
            if (!(object instanceof ItemType)) continue;
            effects.addAll(PotionEffectUtils.getEffects((ItemType)object));
        }
        return effects.toArray(new PotionEffect[0]);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case REMOVE: 
            case ADD: 
            case DELETE: {
                return CollectionUtils.array(PotionEffect[].class, PotionEffectType[].class);
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        block5: for (Object object : this.objects.getArray(e)) {
            switch (mode) {
                case DELETE: {
                    if (object instanceof LivingEntity) {
                        PotionEffectUtils.clearAllEffects((LivingEntity)object);
                        continue block5;
                    }
                    if (!(object instanceof ItemType)) continue block5;
                    PotionEffectUtils.clearAllEffects((ItemType)object);
                    continue block5;
                }
                case ADD: {
                    if (delta == null) {
                        return;
                    }
                    if (object instanceof LivingEntity) {
                        PotionEffectUtils.addEffects((LivingEntity)object, delta);
                        continue block5;
                    }
                    if (!(object instanceof ItemType)) continue block5;
                    PotionEffectUtils.addEffects((ItemType)object, delta);
                    continue block5;
                }
                case REMOVE: {
                    if (delta == null) {
                        return;
                    }
                    if (object instanceof LivingEntity) {
                        PotionEffectUtils.removeEffects((LivingEntity)object, delta);
                        continue block5;
                    }
                    if (!(object instanceof ItemType)) continue block5;
                    PotionEffectUtils.removeEffects((ItemType)object, delta);
                }
            }
        }
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends PotionEffect> getReturnType() {
        return PotionEffect.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean d) {
        return "active potion effects of " + this.objects.toString(e, d);
    }

    static {
        PropertyExpression.register(ExprPotionEffects.class, PotionEffect.class, "[(all [[of] the]|the)] [active] potion effects", "livingentities/itemtypes");
    }
}

