/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.Math2;
import java.util.Random;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Random Number")
@Description(value={"A random number or integer between two given numbers. Use 'number' if you want any number with decimal parts, or use use 'integer' if you only want whole numbers.", "Please note that the order of the numbers doesn't matter, i.e. <code>random number between 2 and 1</code> will work as well as <code>random number between 1 and 2</code>."})
@Examples(value={"set the player's health to a random number between 5 and 10", "send \"You rolled a %random integer from 1 to 6%!\" to the player"})
@Since(value="1.4")
public class ExprRandomNumber
extends SimpleExpression<Number> {
    private Expression<? extends Number> lower;
    private Expression<? extends Number> upper;
    private final Random rand = new Random();
    private boolean integer;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.lower = exprs[0];
        this.upper = exprs[1];
        this.integer = parser.mark == 1;
        return true;
    }

    @Nullable
    protected Number[] get(Event e) {
        Number l = this.lower.getSingle(e);
        Number u = this.upper.getSingle(e);
        if (u == null || l == null) {
            return null;
        }
        double ll = Math.min(l.doubleValue(), u.doubleValue());
        double uu = Math.max(l.doubleValue(), u.doubleValue());
        if (this.integer) {
            return new Long[]{Math2.ceil(ll) + Math2.mod(this.rand.nextLong(), Math2.floor(uu) - Math2.ceil(ll) + 1L)};
        }
        return new Double[]{ll + this.rand.nextDouble() * (uu - ll)};
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return this.integer ? Long.class : Double.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "a random " + (this.integer ? "integer" : "number") + " between " + this.lower.toString(e, debug) + " and " + this.upper.toString(e, debug);
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    static {
        Skript.registerExpression(ExprRandomNumber.class, Number.class, ExpressionType.COMBINED, "[a] random (1\u00a6integer|2\u00a6number) (from|between) %number% (to|and) %number%");
    }
}

