/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Comparators;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.PersistentDataUtils;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Relational Variable")
@Description(value={"A relational variable is a variable stored on an entity, projectile, item, or certain blocks, and it can only be accessed using that entity.", " See <a href='classes.html#persistentdataholder'>persistent data holder</a> for a list of all holders.", " Relational Variables will persist through a server restart, however, just like normal variables,", " not all values can be stored permanently (e.g. entities). If the value can't be stored permanently,", " it will be stored until the server is restarted."})
@Examples(value={"set {isAdmin} of player to true", "set {oldNames::*} of player to \"Noob_Sl4yer\" and \"Skr1pt_M4st3r\""})
@RequiredPlugins(value={"1.14 or newer"})
@Since(value="2.5")
public class ExprRelationalVariable<T>
extends SimpleExpression<T> {
    private ExpressionList<Variable<?>> variables;
    private Expression<Object> holders;
    private ExprRelationalVariable<?> source;
    private Class<? extends T>[] types;
    private Class<T> superType;

    public ExprRelationalVariable() {
        this(null, Object.class);
    }

    private ExprRelationalVariable(ExprRelationalVariable<?> source, Class<? extends T> ... types) {
        this.source = source;
        if (source != null) {
            this.variables = source.variables;
            this.holders = source.holders;
        }
        this.types = types;
        this.superType = Utils.getSuperType(types);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        ExpressionList<Object> exprList = exprs[0] instanceof ExpressionList ? (ExpressionList)exprs[0] : new ExpressionList<Object>(new Expression[]{exprs[0]}, Object.class, false);
        for (Expression expr : exprList.getExpressions()) {
            if (!(expr instanceof Variable)) {
                return false;
            }
            if (!((Variable)expr).isLocal()) continue;
            Skript.error("Setting a relational variable using a local variable is not supported. If you are trying to set a value temporarily, consider using metadata", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.variables = exprList;
        this.holders = exprs[1];
        return true;
    }

    @Override
    @Nullable
    public T[] get(Event e) {
        ArrayList values = new ArrayList();
        Object[] holders = this.holders.getArray(e);
        for (Expression<Variable<?>> expr : this.variables.getExpressions()) {
            String varName = ((Variable)expr).getName().toString(e);
            if (varName.contains("::")) {
                Collections.addAll(values, PersistentDataUtils.getList(varName, holders));
                continue;
            }
            Collections.addAll(values, PersistentDataUtils.getSingle(varName, holders));
        }
        try {
            return Converters.convertArray(values.toArray(), this.types, this.superType);
        }
        catch (ClassCastException ex) {
            return (Object[])Array.newInstance(this.superType, 0);
        }
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET) {
            return null;
        }
        for (Expression<Variable<?>> expr : this.variables.getExpressions()) {
            if (((Variable)expr).isList()) continue;
            if (mode == Changer.ChangeMode.REMOVE_ALL) {
                return null;
            }
            return CollectionUtils.array(Object.class);
        }
        return CollectionUtils.array(Object[].class);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null && mode != Changer.ChangeMode.DELETE) {
            return;
        }
        Object[] holders = this.holders.getArray(e);
        switch (mode) {
            case SET: {
                for (Expression<Variable<?>> expr : this.variables.getExpressions()) {
                    Variable var = (Variable)expr;
                    String varName = var.getName().toString(e);
                    if (var.isList()) {
                        varName = varName.replace("*", "");
                        for (int i = 1; i <= delta.length; ++i) {
                            PersistentDataUtils.setList(varName + i, delta[i - 1], holders);
                        }
                        continue;
                    }
                    if (varName.contains("::")) {
                        PersistentDataUtils.setList(varName, delta[0], holders);
                        continue;
                    }
                    PersistentDataUtils.setSingle(varName, delta[0], holders);
                }
                break;
            }
            case DELETE: {
                for (Expression<Variable<?>> expr : this.variables.getExpressions()) {
                    String varName = ((Variable)expr).getName().toString(e);
                    if (varName.contains("::")) {
                        PersistentDataUtils.removeList(varName, holders);
                        continue;
                    }
                    PersistentDataUtils.removeSingle(varName, holders);
                }
                break;
            }
            case ADD: {
                for (Expression<Variable<?>> expr : this.variables.getExpressions()) {
                    Variable var = (Variable)expr;
                    String varName = var.getName().toString(e);
                    if (var.isList()) {
                        varName = varName.replace("*", "");
                        for (Object holder : holders) {
                            Set<String> varIndexes = PersistentDataUtils.getListIndexes(varName + "*", holder);
                            if (varIndexes == null) {
                                for (int i = 1; i <= delta.length; ++i) {
                                    PersistentDataUtils.setList(varName + i, delta[i - 1], holder);
                                }
                                continue;
                            }
                            int start = 1 + varIndexes.size();
                            for (Object value : delta) {
                                while (varIndexes.contains(String.valueOf(start))) {
                                    ++start;
                                }
                                PersistentDataUtils.setList(varName + start, value, holder);
                                ++start;
                            }
                        }
                        continue;
                    }
                    if (!(delta[0] instanceof Number)) continue;
                    for (Object holder : holders) {
                        Object[] n = PersistentDataUtils.getSingle(varName, holder);
                        double oldValue = 0.0;
                        if (n.length != 0 && n[0] instanceof Number) {
                            oldValue = ((Number)n[0]).doubleValue();
                        }
                        PersistentDataUtils.setSingle(varName, oldValue + ((Number)delta[0]).doubleValue(), holder);
                    }
                }
                break;
            }
            case REMOVE: 
            case REMOVE_ALL: {
                for (Expression<Variable<?>> expr : this.variables.getExpressions()) {
                    Variable var = (Variable)expr;
                    String varName = var.getName().toString(e);
                    if (var.isList() || mode == Changer.ChangeMode.REMOVE_ALL) {
                        for (Object holder : holders) {
                            Map<String, Object> varMap = PersistentDataUtils.getListMap(varName, holder);
                            int sizeBefore = varMap.size();
                            if (varMap == null) continue;
                            for (Object value : delta) {
                                varMap.entrySet().removeIf(entry -> Comparator.Relation.EQUAL.is(Comparators.compare(entry.getValue(), value)));
                            }
                            if (sizeBefore == varMap.size()) continue;
                            PersistentDataUtils.setListMap(varName, varMap, holder);
                        }
                        continue;
                    }
                    if (!(delta[0] instanceof Number)) continue;
                    for (Object holder : holders) {
                        Object[] n = PersistentDataUtils.getSingle(varName, holder);
                        double oldValue = 0.0;
                        if (n.length != 0 && n[0] instanceof Number) {
                            oldValue = ((Number)n[0]).doubleValue();
                        }
                        PersistentDataUtils.setSingle(varName, oldValue - ((Number)delta[0]).doubleValue(), holder);
                    }
                }
                break;
            }
            case RESET: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public boolean isSingle() {
        return this.variables.isSingle() && this.holders.isSingle();
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.superType;
    }

    @Override
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        return new ExprRelationalVariable<R>(this, to);
    }

    @Override
    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.variables.toString(e, debug) + " of " + this.holders.toString(e, debug);
    }
}

