/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Shuffled List")
@Description(value={"Shuffles given list randomly. This is done by replacing indices by random numbers in resulting list."})
@Examples(value={"set {_list::*} to shuffled {_list::*}"})
@Since(value="2.2-dev32")
public class ExprShuffledList
extends SimpleExpression<Object> {
    private Expression<?> list;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.list = LiteralUtils.defendExpression(exprs[0]);
        return LiteralUtils.canInitSafely(this.list);
    }

    @Override
    @Nullable
    protected Object[] get(Event e) {
        Object[] origin = (Object[])this.list.getArray(e).clone();
        List<Object> shuffled = Arrays.asList(origin);
        Collections.shuffle(shuffled);
        Object[] array = (Object[])Array.newInstance(this.getReturnType(), origin.length);
        return shuffled.toArray(array);
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.list.getReturnType();
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "shuffled " + this.list.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprShuffledList.class, Object.class, ExpressionType.COMBINED, "shuffled %objects%");
    }
}

