/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Spawner Type")
@Description(value={"Retrieves, sets, or resets the spawner's entity type"})
@Examples(value={"on right click:", "\tif event-block is spawner:", "\t\tsend \"Spawner's type is %target block's entity type%\""})
@Since(value="2.4")
public class ExprSpawnerType
extends SimplePropertyExpression<Block, EntityData> {
    private static final Material MATERIAL_SPAWNER = Aliases.javaItemType("spawner").getMaterial();
    private static final BiMap<EntityData, EntityType> CACHE = HashBiMap.create();

    @Override
    @Nullable
    public EntityData convert(Block b) {
        if (b.getType() != MATERIAL_SPAWNER) {
            return null;
        }
        return ExprSpawnerType.toSkriptEntityData(((CreatureSpawner)b.getState()).getSpawnedType());
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return CollectionUtils.array(EntityData.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        for (Block b : (Block[])this.getExpr().getArray(e)) {
            if (b.getType() != MATERIAL_SPAWNER) continue;
            CreatureSpawner s = (CreatureSpawner)b.getState();
            switch (mode) {
                case SET: {
                    s.setSpawnedType(ExprSpawnerType.toBukkitEntityType((EntityData)delta[0]));
                    break;
                }
                case RESET: {
                    s.setSpawnedType(EntityType.PIG);
                }
            }
            s.update();
        }
    }

    @Override
    public Class<EntityData> getReturnType() {
        return EntityData.class;
    }

    @Override
    protected String getPropertyName() {
        return "entity type";
    }

    private static EntityType toBukkitEntityType(EntityData e) {
        return (EntityType)CACHE.get(EntityData.fromClass(e.getType()));
    }

    private static EntityData toSkriptEntityData(EntityType e) {
        return (EntityData)CACHE.inverse().get((Object)e);
    }

    static {
        for (EntityType e : EntityType.values()) {
            Class c = e.getEntityClass();
            if (c == null) continue;
            CACHE.put(EntityData.fromClass(c), (Object)e);
        }
        ExprSpawnerType.register(ExprSpawnerType.class, EntityData.class, "(entity|creature) type[s]", "blocks");
    }
}

