/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Time Played")
@Description(value={"The amount of time a player has played for on the server. This info is stored in the player's statistics in the main world's data folder. Changing this will also change the player's stats which can be views in the client's statistics menu."})
@Examples(value={"set {_t} to time played of player", "if player's time played is greater than 10 minutes:", "\tgive player a diamond sword", "set player's time played to 0 seconds"})
@Since(value="2.5")
public class ExprTimePlayed
extends SimplePropertyExpression<Player, Timespan> {
    private static final Statistic TIME_PLAYED;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    @Override
    @Nullable
    public Timespan convert(Player player) {
        return Timespan.fromTicks_i(player.getStatistic(TIME_PLAYED));
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return CollectionUtils.array(Timespan.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            return;
        }
        long ticks = ((Timespan)delta[0]).getTicks_i();
        for (Player player : (Player[])this.getExpr().getArray(e)) {
            long playerTicks = player.getStatistic(TIME_PLAYED);
            switch (mode) {
                case ADD: {
                    ticks = playerTicks + ticks;
                    break;
                }
                case REMOVE: {
                    ticks = playerTicks - ticks;
                }
            }
            player.setStatistic(TIME_PLAYED, (int)ticks);
        }
    }

    @Override
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    @Override
    protected String getPropertyName() {
        return "time played";
    }

    static {
        ExprTimePlayed.register(ExprTimePlayed.class, Timespan.class, "time played", "players");
        TIME_PLAYED = Skript.isRunningMinecraft(1, 13) ? Statistic.PLAY_ONE_MINUTE : Statistic.valueOf((String)"PLAY_ONE_TICK");
    }
}

