/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.WrapperExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Former/Future State")
@Description(value={"Represents the value of an expression before an event happened or the value it will have directly after the event, e.g. the old or new level respectively in a <a href='../events.html#level_change'>level change event</a>.", "Note: The past, future and present states of an expression are sometimes called 'time states' of an expression.", "Note 2: If you don't specify whether to use the past or future state of an expression that has different values, its default value will be used which is usually the value after the event."})
@Examples(value={"on teleport:", "\tformer world was \"world_nether\" # or 'world was'", "\tworld will be \"world\" # or 'world after the event is'", "on tool change:", "\tpast tool is an axe", "\tthe tool after the event will be air", "on weather change:", "\tset {weather::%world%::old} to past weather", "\tset {weather::%world%::current} to the new weather"})
@Since(value="1.1")
public class ExprTimeState
extends WrapperExpression<Object> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Expression<?> expr = exprs[0];
        if (isDelayed == Kleenean.TRUE) {
            Skript.error("Cannot use time states after the event has already passed", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        if (!expr.setTime(matchedPattern >= 2 ? 1 : -1)) {
            Skript.error(expr + " does not have a " + (matchedPattern >= 2 ? "future" : "past") + " state", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.setExpr(expr);
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the " + (this.getTime() == -1 ? "past" : "future") + " state of " + this.getExpr().toString(e, debug);
    }

    @Override
    public boolean setTime(int time) {
        return time == this.getTime();
    }

    static {
        Skript.registerExpression(ExprTimeState.class, Object.class, ExpressionType.PROPERTY, "[the] (former|past|old) [state] [of] %~object%", "%~object% before [the event]", "[the] (future|to-be|new) [state] [of] %~object%", "%~object%(-to-be| after[(wards| the event)])");
    }
}

