/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.NoDoc;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Kleenean;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@NoDoc
public class ExprTimes
extends SimpleExpression<Number> {
    private Expression<Number> end;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Expression<Integer> expression = this.end = matchedPattern == 0 ? exprs[0] : new SimpleLiteral<Integer>(matchedPattern, false);
        if (this.end instanceof Literal) {
            int amount = ((Number)((Literal)this.end).getSingle()).intValue();
            if (amount == 0 && this.isInLoop()) {
                Skript.warning("Looping zero times makes the code inside of the loop useless");
            } else if (amount == 1 & this.isInLoop()) {
                Skript.warning("Since you're looping exactly one time, you could simply remove the loop instead");
            } else if (amount < 0) {
                if (this.isInLoop()) {
                    Skript.error("Looping a negative amount of times is impossible");
                } else {
                    Skript.error("The times expression only supports positive numbers");
                }
                return false;
            }
        }
        return true;
    }

    private boolean isInLoop() {
        Node node = SkriptLogger.getNode();
        if (node == null) {
            return false;
        }
        String key = node.getKey();
        if (key == null) {
            return false;
        }
        return key.startsWith("loop ");
    }

    @Nullable
    protected Number[] get(Event e) {
        Iterator<? extends Integer> iter = this.iterator(e);
        if (iter == null) {
            return null;
        }
        return (Number[])Iterators.toArray(iter, Integer.class);
    }

    @Override
    @Nullable
    public Iterator<? extends Integer> iterator(Event e) {
        Number end = this.end.getSingle(e);
        if (end == null) {
            return null;
        }
        return IntStream.range(1, end.intValue() + 1).iterator();
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.end.toString(e, debug) + " times";
    }

    static {
        Skript.registerExpression(ExprTimes.class, Number.class, ExpressionType.SIMPLE, "%number% time[s]", "once", "twice");
    }
}

