/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Normalized")
@Description(value={"Returns the same vector but with length 1."})
@Examples(value={"set {_v} to normalized {_v}"})
@Since(value="2.2-dev28")
public class ExprVectorNormalize
extends SimpleExpression<Vector> {
    private Expression<Vector> vector;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.vector = exprs[0];
        return true;
    }

    protected Vector[] get(Event e) {
        Vector v = this.vector.getSingle(e);
        if (v == null) {
            return null;
        }
        return CollectionUtils.array(v.clone().normalize());
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "normalized " + this.vector.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprVectorNormalize.class, Vector.class, ExpressionType.SIMPLE, "normalize[d] %vector%", "%vector% normalized");
    }
}

