/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.VectorMath;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Yaw and Pitch")
@Description(value={"Gets or sets the yaw or pitch value of a vector."})
@Examples(value={"set {_v} to vector -1, 1, 1", "send \"%vector yaw of {_v}%, %vector pitch of {_v}%\"", "add 45 to vector yaw of {_v}", "subtract 45 from vector pitch of {_v}", "send \"%vector yaw of {_v}%, %vector pitch of {_v}%\"", "set vector yaw of {_v} to -45", "set vector pitch of {_v} to 45", "send \"%vector yaw of {_v}%, %vector pitch of {_v}%\""})
@Since(value="2.2-dev28")
public class ExprVectorYawPitch
extends SimplePropertyExpression<Vector, Number> {
    private boolean usesYaw;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.usesYaw = parseResult.mark == 0;
        return true;
    }

    @Override
    public Number convert(Vector vector) {
        if (this.usesYaw) {
            return Float.valueOf(VectorMath.skriptYaw(VectorMath.getYaw(vector)));
        }
        return Float.valueOf(VectorMath.skriptPitch(VectorMath.getPitch(vector)));
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if ((mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) && this.getExpr().isSingle() && Changer.ChangerUtils.acceptsChange(this.getExpr(), Changer.ChangeMode.SET, Vector.class)) {
            return CollectionUtils.array(Number.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        assert (delta != null);
        Vector v = (Vector)this.getExpr().getSingle(e);
        if (v == null) {
            return;
        }
        float n = ((Number)delta[0]).floatValue();
        float yaw = VectorMath.getYaw(v);
        float pitch = VectorMath.getPitch(v);
        switch (mode) {
            case ADD: {
                if (this.usesYaw) {
                    yaw += n;
                } else {
                    pitch -= n;
                }
                v = VectorMath.fromYawAndPitch(yaw, pitch);
                this.getExpr().change(e, new Vector[]{v}, Changer.ChangeMode.SET);
                break;
            }
            case REMOVE: {
                n = -n;
            }
            case SET: {
                if (this.usesYaw) {
                    yaw = VectorMath.fromSkriptYaw(n);
                } else {
                    pitch = VectorMath.fromSkriptPitch(n);
                }
                v = VectorMath.fromYawAndPitch(yaw, pitch);
                this.getExpr().change(e, new Vector[]{v}, Changer.ChangeMode.SET);
            }
        }
    }

    @Override
    protected String getPropertyName() {
        return this.usesYaw ? "yaw" : "pitch";
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprVectorYawPitch.register(ExprVectorYawPitch.class, Number.class, "[vector] (0\u00a6yaw|1\u00a6pitch)", "vectors");
    }
}

