/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.eclipse.jdt.annotation.Nullable;
import org.spigotmc.event.entity.EntityDismountEvent;
import org.spigotmc.event.entity.EntityMountEvent;

@Name(value="Vehicle")
@Description(value={"The vehicle an entity is in, if any. This can actually be any entity, e.g. spider jockeys are skeletons that ride on a spider, so the spider is the 'vehicle' of the skeleton.", "See also: <a href='#ExprPassenger'>passenger</a>"})
@Examples(value={"vehicle of the player is a minecart"})
@Since(value="2.0")
public class ExprVehicle
extends SimplePropertyExpression<Entity, Entity> {
    static final boolean hasMountEvents = Skript.classExists("org.spigotmc.event.entity.EntityMountEvent");

    protected Entity[] get(final Event e, Entity[] source) {
        return this.get(source, new Converter<Entity, Entity>(){

            @Override
            @Nullable
            public Entity convert(Entity p) {
                if (ExprVehicle.this.getTime() >= 0 && e instanceof VehicleEnterEvent && p.equals(((VehicleEnterEvent)e).getEntered()) && !Delay.isDelayed(e)) {
                    return ((VehicleEnterEvent)e).getVehicle();
                }
                if (ExprVehicle.this.getTime() >= 0 && e instanceof VehicleExitEvent && p.equals(((VehicleExitEvent)e).getExited()) && !Delay.isDelayed(e)) {
                    return ((VehicleExitEvent)e).getVehicle();
                }
                if (hasMountEvents) {
                    if (ExprVehicle.this.getTime() >= 0 && e instanceof EntityMountEvent && p.equals(((EntityMountEvent)e).getEntity()) && !Delay.isDelayed(e)) {
                        return ((EntityMountEvent)e).getMount();
                    }
                    if (ExprVehicle.this.getTime() >= 0 && e instanceof EntityDismountEvent && p.equals(((EntityDismountEvent)e).getEntity()) && !Delay.isDelayed(e)) {
                        return ((EntityDismountEvent)e).getDismounted();
                    }
                }
                return p.getVehicle();
            }
        });
    }

    @Override
    @Nullable
    public Entity convert(Entity e) {
        assert (false);
        return e.getVehicle();
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    @Override
    protected String getPropertyName() {
        return "vehicle";
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{Entity.class, EntityData.class};
        }
        return super.acceptChange(mode);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            assert (delta != null);
            Entity[] ps = (Entity[])this.getExpr().getArray(e);
            if (ps.length == 0) {
                return;
            }
            Object o = delta[0];
            if (o instanceof Entity) {
                ((Entity)o).eject();
                Entity p = CollectionUtils.getRandom(ps);
                assert (p != null);
                p.leaveVehicle();
                ((Entity)o).setPassenger(p);
            } else if (o instanceof EntityData) {
                for (Entity p : ps) {
                    Object v = ((EntityData)o).spawn(p.getLocation());
                    if (v == null) continue;
                    v.setPassenger(p);
                }
            } else assert (false);
        } else {
            super.change(e, delta, mode);
        }
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.getExpr(), VehicleEnterEvent.class, VehicleExitEvent.class);
    }

    static {
        ExprVehicle.register(ExprVehicle.class, Entity.class, "vehicle[s]", "entities");
    }
}

