/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.WeatherType;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.weather.WeatherEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Weather")
@Description(value={"The weather in the given or the current world."})
@Examples(value={"set weather to clear", "weather in \"world\" is rainy"})
@Since(value="1.0")
@Events(value={"weather change"})
public class ExprWeather
extends PropertyExpression<World, WeatherType> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected WeatherType[] get(final Event e, World[] source) {
        return this.get(source, new Getter<WeatherType, World>(){

            @Override
            public WeatherType get(World w) {
                if (ExprWeather.this.getTime() >= 0 && e instanceof WeatherEvent && w.equals(((WeatherEvent)e).getWorld()) && !Delay.isDelayed(e)) {
                    return WeatherType.fromEvent((WeatherEvent)e);
                }
                return WeatherType.fromWorld(w);
            }
        });
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the weather in " + this.getExpr().toString(e, debug);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.SET) {
            return CollectionUtils.array(WeatherType.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        WeatherType t = delta == null ? WeatherType.CLEAR : (WeatherType)((Object)delta[0]);
        for (World w : (World[])this.getExpr().getArray(e)) {
            assert (w != null) : this.getExpr();
            if (this.getTime() >= 0 && e instanceof WeatherEvent && w.equals(((WeatherEvent)e).getWorld()) && !Delay.isDelayed(e)) {
                if (e instanceof WeatherChangeEvent) {
                    if (((WeatherChangeEvent)e).toWeatherState() && t == WeatherType.CLEAR) {
                        ((WeatherChangeEvent)e).setCancelled(true);
                    }
                    if (((WeatherChangeEvent)e).getWorld().isThundering() == (t == WeatherType.THUNDER)) continue;
                    ((WeatherChangeEvent)e).getWorld().setThundering(t == WeatherType.THUNDER);
                    continue;
                }
                if (!(e instanceof ThunderChangeEvent)) continue;
                if (((ThunderChangeEvent)e).toThunderState() && t != WeatherType.THUNDER) {
                    ((ThunderChangeEvent)e).setCancelled(true);
                }
                if (((ThunderChangeEvent)e).getWorld().hasStorm() != (t == WeatherType.CLEAR)) continue;
                ((ThunderChangeEvent)e).getWorld().setStorm(t != WeatherType.CLEAR);
                continue;
            }
            t.setWeather(w);
        }
    }

    @Override
    public Class<WeatherType> getReturnType() {
        return WeatherType.class;
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.getExpr(), WeatherChangeEvent.class, ThunderChangeEvent.class);
    }

    static {
        Skript.registerExpression(ExprWeather.class, WeatherType.class, ExpressionType.PROPERTY, "[the] weather [(in|of) %worlds%]", "%worlds%'[s] weather");
    }
}

