/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Yaw / Pitch")
@Description(value={"The yaw or pitch of a location. You likely won't need this expression ever if you don't know what this means."})
@Examples(value={"log \"%player%: %location of player%, %player's yaw%, %player's pitch%\" to \"playerlocs.log\""})
@Since(value="2.0")
public class ExprYawPitch
extends SimplePropertyExpression<Location, Number> {
    public static boolean randomSK = true;
    private boolean yaw;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.yaw = parseResult.mark == 0;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Override
    public Number convert(Location l) {
        return Float.valueOf(this.yaw ? this.convertToPositive(l.getYaw()) : l.getPitch());
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    protected String getPropertyName() {
        return this.yaw ? "yaw" : "pitch";
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return CollectionUtils.array(Number.class);
        }
        return null;
    }

    @Override
    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Location l = (Location)this.getExpr().getSingle(e);
        if (delta[0] == null || l == null) {
            return;
        }
        float f = ((Number)delta[0]).floatValue();
        switch (mode) {
            case SET: {
                if (this.yaw) {
                    l.setYaw(this.convertToPositive(f));
                    break;
                }
                l.setPitch(f);
                break;
            }
            case ADD: {
                if (this.yaw) {
                    l.setYaw(this.convertToPositive(l.getYaw()) + f);
                    break;
                }
                l.setPitch(l.getPitch() + f);
                break;
            }
            case REMOVE: {
                if (this.yaw) {
                    l.setYaw(this.convertToPositive(l.getYaw()) - f);
                    break;
                }
                l.setPitch(l.getPitch() - f);
                break;
            }
        }
    }

    public float convertToPositive(float f) {
        if (f != 0.0f && f * -1.0f == Math.abs(f)) {
            return 360.0f + f;
        }
        return f;
    }

    static {
        ExprYawPitch.register(ExprYawPitch.class, Number.class, "(0\u00a6yaw|1\u00a6pitch)", "locations");
    }
}

