/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.LiteralList;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class ExpressionList<T>
implements Expression<T> {
    protected final Expression<? extends T>[] expressions;
    protected boolean and;
    private final boolean single;
    private final Class<T> returnType;
    @Nullable
    private ExpressionList<?> source;
    private int time = 0;

    public ExpressionList(Expression<? extends T>[] expressions, Class<T> returnType, boolean and) {
        this(expressions, returnType, and, null);
    }

    protected ExpressionList(Expression<? extends T>[] expressions, Class<T> returnType, boolean and, @Nullable ExpressionList<?> source) {
        assert (expressions != null);
        this.expressions = expressions;
        this.returnType = returnType;
        this.and = and;
        if (and) {
            this.single = false;
        } else {
            boolean single = true;
            for (Expression<T> expression : expressions) {
                if (expression.isSingle()) continue;
                single = false;
                break;
            }
            this.single = single;
        }
        this.source = source;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public T getSingle(Event e) {
        if (!this.single) {
            throw new UnsupportedOperationException();
        }
        for (int i : CollectionUtils.permutation(this.expressions.length)) {
            T t = this.expressions[i].getSingle(e);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    public T[] getArray(Event e) {
        if (this.and) {
            return this.getAll(e);
        }
        for (int i : CollectionUtils.permutation(this.expressions.length)) {
            T[] t = this.expressions[i].getArray(e);
            if (t.length <= 0) continue;
            return t;
        }
        Object[] r = (Object[])Array.newInstance(this.returnType, 0);
        assert (r != null);
        return r;
    }

    @Override
    public T[] getAll(Event e) {
        ArrayList<T> r = new ArrayList<T>();
        for (Expression<T> expression : this.expressions) {
            r.addAll(Arrays.asList(expression.getAll(e)));
        }
        return r.toArray((Object[])Array.newInstance(this.returnType, r.size()));
    }

    @Override
    @Nullable
    public Iterator<? extends T> iterator(final Event e) {
        if (!this.and) {
            for (int i : CollectionUtils.permutation(this.expressions.length)) {
                Iterator<T> t = this.expressions[i].iterator(e);
                if (t == null || !t.hasNext()) continue;
                return t;
            }
            return null;
        }
        return new Iterator<T>(){
            private int i = 0;
            @Nullable
            private Iterator<? extends T> current = null;

            @Override
            public boolean hasNext() {
                Iterator c = this.current;
                while (!(this.i >= ExpressionList.this.expressions.length || c != null && c.hasNext())) {
                    c = ExpressionList.this.expressions[this.i++].iterator(e);
                    this.current = c;
                }
                return c != null && c.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Iterator c = this.current;
                if (c == null) {
                    throw new NoSuchElementException();
                }
                Object t = c.next();
                assert (t != null) : this.current;
                return t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isSingle() {
        return this.single;
    }

    @Override
    public boolean check(Event e, Checker<? super T> c, boolean negated) {
        return negated ^ this.check(e, c);
    }

    @Override
    public boolean check(Event e, Checker<? super T> c) {
        for (Expression<? super T> expression : this.expressions) {
            Boolean b = expression.check(e, c);
            if (this.and && !b.booleanValue()) {
                return false;
            }
            if (this.and || !b.booleanValue()) continue;
            return true;
        }
        return this.and;
    }

    @Override
    @Nullable
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        Expression[] exprs = new Expression[this.expressions.length];
        for (int i = 0; i < exprs.length; ++i) {
            exprs[i] = this.expressions[i].getConvertedExpression(to);
            if (exprs[i] != null) continue;
            return null;
        }
        return new ExpressionList(exprs, Utils.getSuperType(to), this.and, this);
    }

    @Override
    public Class<T> getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean getAnd() {
        return this.and;
    }

    public boolean setAnd(boolean and) {
        boolean r = and;
        this.and = and;
        return r;
    }

    public void invertAnd() {
        this.and = !this.and;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class<?>[] exprClasses = this.expressions[0].acceptChange(mode);
        if (exprClasses == null) {
            return null;
        }
        ArrayList acceptedClasses = new ArrayList(Arrays.asList(exprClasses));
        for (int i = 1; i < this.expressions.length; ++i) {
            exprClasses = this.expressions[i].acceptChange(mode);
            if (exprClasses == null) {
                return null;
            }
            acceptedClasses.retainAll(Arrays.asList(exprClasses));
            if (!acceptedClasses.isEmpty()) continue;
            return null;
        }
        return acceptedClasses.toArray(new Class[0]);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        for (Expression<T> expression : this.expressions) {
            expression.change(e, delta, mode);
        }
    }

    @Override
    public boolean setTime(int time) {
        boolean ok = false;
        for (Expression<T> expression : this.expressions) {
            ok |= expression.setTime(time);
        }
        if (ok) {
            this.time = time;
        }
        return ok;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public boolean isLoopOf(String s) {
        for (Expression<T> expression : this.expressions) {
            if (!expression.isLoopOf(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Expression<?> getSource() {
        ExpressionList<?> s = this.source;
        return s == null ? this : s;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        StringBuilder b = new StringBuilder("(");
        for (int i = 0; i < this.expressions.length; ++i) {
            if (i != 0) {
                if (i == this.expressions.length - 1) {
                    b.append(this.and ? " and " : " or ");
                } else {
                    b.append(", ");
                }
            }
            b.append(this.expressions[i].toString(e, debug));
        }
        b.append(")");
        if (debug) {
            b.append("[").append(this.returnType).append("]");
        }
        return "" + b;
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    public Expression<? extends T>[] getExpressions() {
        return this.expressions;
    }

    @Override
    public Expression<T> simplify() {
        boolean isLiteralList = true;
        boolean isSimpleList = true;
        for (int i = 0; i < this.expressions.length; ++i) {
            this.expressions[i] = this.expressions[i].simplify();
            isLiteralList &= this.expressions[i] instanceof Literal;
            isSimpleList &= this.expressions[i].isSingle();
        }
        if (isLiteralList && isSimpleList) {
            Object[] values = (Object[])Array.newInstance(this.returnType, this.expressions.length);
            for (int i = 0; i < values.length; ++i) {
                values[i] = ((Literal)this.expressions[i]).getSingle();
            }
            return new SimpleLiteral<Object>(values, this.returnType, this.and);
        }
        if (isLiteralList) {
            Literal[] ls = (Literal[])Arrays.copyOf(this.expressions, this.expressions.length, Literal[].class);
            assert (ls != null);
            return new LiteralList<T>(ls, this.returnType, this.and);
        }
        return this;
    }
}

