/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.ContainerExpression;
import ch.njol.skript.util.Container;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class Loop
extends TriggerSection {
    private final Expression<?> expr;
    private final transient Map<Event, Object> current = new WeakHashMap<Event, Object>();
    private final transient Map<Event, Iterator<?>> currentIter = new WeakHashMap();
    @Nullable
    private TriggerItem actualNext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Loop(Expression<?> expr, SectionNode node) {
        assert (expr != null);
        assert (node != null);
        if (Container.class.isAssignableFrom(expr.getReturnType())) {
            Container.ContainerType type = expr.getReturnType().getAnnotation(Container.ContainerType.class);
            if (type == null) {
                throw new SkriptAPIException(expr.getReturnType().getName() + " implements Container but is missing the required @ContainerType annotation");
            }
            this.expr = new ContainerExpression(expr, type.value());
        } else {
            this.expr = expr;
        }
        ParserInstance parserInstance = ParserInstance.get();
        List<TriggerSection> currentSections = parserInstance.getCurrentSections();
        List<Loop> currentLoops = parserInstance.getCurrentLoops();
        currentSections.add(this);
        currentLoops.add(this);
        try {
            this.setTriggerItems(ScriptLoader.loadItems(node));
        }
        finally {
            currentLoops.remove(currentLoops.size() - 1);
            currentSections.remove(currentSections.size() - 1);
        }
        super.setNext(this);
    }

    @Override
    @Nullable
    protected TriggerItem walk(Event e) {
        Iterator<?> iter = this.currentIter.get(e);
        if (iter == null) {
            Iterator<Object> iterator = iter = this.expr instanceof Variable ? ((Variable)this.expr).variablesIterator(e) : this.expr.iterator(e);
            if (iter != null) {
                if (iter.hasNext()) {
                    this.currentIter.put(e, iter);
                } else {
                    iter = null;
                }
            }
        }
        if (iter == null || !iter.hasNext()) {
            this.exit(e);
            this.debug(e, false);
            return this.actualNext;
        }
        this.current.put(e, iter.next());
        return this.walk(e, true);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "loop " + this.expr.toString(e, debug);
    }

    @Nullable
    public Object getCurrent(Event e) {
        return this.current.get(e);
    }

    public Expression<?> getLoopedExpression() {
        return this.expr;
    }

    @Override
    public Loop setNext(@Nullable TriggerItem next) {
        this.actualNext = next;
        return this;
    }

    @Nullable
    public TriggerItem getActualNext() {
        return this.actualNext;
    }

    public void exit(Event event) {
        this.current.remove(event);
        this.currentIter.remove(event);
    }
}

