/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.command.ScriptCommandEvent;
import ch.njol.skript.config.Config;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.LiteralList;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.function.ExprFunctionCall;
import ch.njol.skript.lang.function.FunctionReference;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.ScriptOptions;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import org.bukkit.event.EventPriority;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class SkriptParser {
    final String expr;
    public static final int PARSE_EXPRESSIONS = 1;
    public static final int PARSE_LITERALS = 2;
    public static final int ALL_FLAGS = 3;
    private final int flags;
    public final ParseContext context;
    public static final String wildcard = "[^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?";
    public static final String stringMatcher = "\"[^\"]*?(?:\"\"[^\"]*)*?\"";
    private static final Pattern varPattern = Pattern.compile("((the )?var(iable)? )?\\{([^{}]|%\\{|\\}%)+\\}", 2);
    public static final Pattern listSplitPattern = Pattern.compile("\\s*,?\\s+(and|n?or)\\s+|\\s*,\\s*", 2);
    private static final String MULTIPLE_AND_OR = "List has multiple 'and' or 'or', will default to 'and'. Use brackets if you want to define multiple lists.";
    private static final String MISSING_AND_OR = "List is missing 'and' or 'or', defaulting to 'and'";
    private boolean suppressMissingAndOrWarnings = SkriptConfig.disableMissingAndOrWarnings.value();
    private static final Pattern functionCallPattern = Pattern.compile("([\\p{IsAlphabetic}][\\p{IsAlphabetic}\\p{IsDigit}_]*)\\((.*)\\)");
    private static final Message m_quotes_error = new Message("skript.quotes error");
    private static final Message m_brackets_error = new Message("skript.brackets error");
    private static final Map<String, ExprInfo> exprInfoCache = new HashMap<String, ExprInfo>();

    public SkriptParser(String expr) {
        this(expr, 3);
    }

    public SkriptParser(String expr, int flags) {
        this(expr, flags, ParseContext.DEFAULT);
    }

    public SkriptParser(String expr, int flags, ParseContext context) {
        assert (expr != null);
        assert ((flags & 3) != 0);
        this.expr = "" + expr.trim();
        this.flags = flags;
        this.context = context;
    }

    public SkriptParser(SkriptParser other, String expr) {
        this(expr, other.flags, other.context);
    }

    @Nullable
    public static <T> Literal<? extends T> parseLiteral(String expr, Class<T> c, ParseContext context) {
        expr = "" + expr.trim();
        if (expr.isEmpty()) {
            return null;
        }
        return new UnparsedLiteral(expr).getConvertedExpression(context, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T extends SyntaxElement> T parse(String expr, Iterator<? extends SyntaxElementInfo<T>> source, @Nullable String defaultError) {
        expr = "" + expr.trim();
        if (expr.isEmpty()) {
            Skript.error(defaultError);
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            T e = new SkriptParser(expr).parse(source);
            if (e != null) {
                log.printLog();
                T t = e;
                return t;
            }
            log.printError(defaultError);
            T t = null;
            return t;
        }
        finally {
            log.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T extends SyntaxElement> T parseStatic(String expr, Iterator<? extends SyntaxElementInfo<? extends T>> source, @Nullable String defaultError) {
        expr = "" + expr.trim();
        if (expr.isEmpty()) {
            Skript.error(defaultError);
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            T e = new SkriptParser(expr, 2).parse(source);
            if (e != null) {
                log.printLog();
                T t = e;
                return t;
            }
            log.printError(defaultError);
            T t = null;
            return t;
        }
        finally {
            log.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private final <T extends SyntaxElement> T parse(Iterator<? extends SyntaxElementInfo<? extends T>> source) {
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            while (source.hasNext()) {
                SyntaxElementInfo<T> info = source.next();
                block8: for (int i = 0; i < info.patterns.length; ++i) {
                    log.clear();
                    try {
                        String pattern = info.patterns[i];
                        assert (pattern != null);
                        ParseResult res = this.parse_i(pattern, 0, 0);
                        if (res == null) continue;
                        int x = -1;
                        int j = 0;
                        while ((x = SkriptParser.nextUnescaped(pattern, '%', x + 1)) != -1) {
                            String name;
                            int x2 = SkriptParser.nextUnescaped(pattern, '%', x + 1);
                            if (res.exprs[j] == null && !(name = pattern.substring(x + 1, x2)).startsWith("-")) {
                                ExprInfo vi = SkriptParser.getExprInfo(name);
                                DefaultExpression<?> expr = vi.classes[0].getDefaultExpression();
                                if (expr == null) {
                                    throw new SkriptAPIException("The class '" + vi.classes[0].getCodeName() + "' does not provide a default expression. Either allow null (with %-" + vi.classes[0].getCodeName() + "%) or make it mandatory [pattern: " + info.patterns[i] + "]");
                                }
                                if (!(expr instanceof Literal) && (vi.flagMask & 1) == 0) {
                                    throw new SkriptAPIException("The default expression of '" + vi.classes[0].getCodeName() + "' is not a literal. Either allow null (with %-*" + vi.classes[0].getCodeName() + "%) or make it mandatory [pattern: " + info.patterns[i] + "]");
                                }
                                if (expr instanceof Literal && (vi.flagMask & 2) == 0) {
                                    throw new SkriptAPIException("The default expression of '" + vi.classes[0].getCodeName() + "' is a literal. Either allow null (with %-~" + vi.classes[0].getCodeName() + "%) or make it mandatory [pattern: " + info.patterns[i] + "]");
                                }
                                if (!vi.isPlural[0] && !expr.isSingle()) {
                                    throw new SkriptAPIException("The default expression of '" + vi.classes[0].getCodeName() + "' is not a single-element expression. Change your pattern to allow multiple elements or make the expression mandatory [pattern: " + info.patterns[i] + "]");
                                }
                                if (vi.time != 0 && !expr.setTime(vi.time)) {
                                    throw new SkriptAPIException("The default expression of '" + vi.classes[0].getCodeName() + "' does not have distinct time states. [pattern: " + info.patterns[i] + "]");
                                }
                                if (!expr.init()) continue block8;
                                res.exprs[j] = expr;
                            }
                            x = x2;
                            ++j;
                        }
                        SyntaxElement t = (SyntaxElement)info.c.newInstance();
                        if (!t.init(res.exprs, i, SkriptParser.getParser().getHasDelayBefore(), res)) continue;
                        log.printLog();
                        SyntaxElement syntaxElement = t;
                        return (T)syntaxElement;
                    }
                    catch (InstantiationException e) {
                        assert (false);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        assert (false);
                        continue;
                    }
                }
            }
            log.printError();
            T t = null;
            return t;
        }
        finally {
            log.stop();
        }
    }

    @Nullable
    private static <T> Variable<T> parseVariable(String expr, Class<? extends T>[] returnTypes) {
        if (varPattern.matcher(expr).matches()) {
            return Variable.newInstance("" + expr.substring(expr.indexOf(123) + 1, expr.lastIndexOf(125)), returnTypes);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final <T> Expression<? extends T> parseSingleExpr(boolean allowUnparsedLiteral, @Nullable LogEntry error, Class<? extends T> ... types) {
        assert (types.length > 0);
        assert (types.length == 1 || !CollectionUtils.contains(types, Object.class));
        if (this.expr.isEmpty()) {
            return null;
        }
        if (this.context != ParseContext.COMMAND && this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
            return new SkriptParser(this, "" + this.expr.substring(1, this.expr.length() - 1)).parseSingleExpr(allowUnparsedLiteral, error, types);
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            Expression<String> e;
            if (this.context == ParseContext.DEFAULT || this.context == ParseContext.EVENT) {
                Variable<? extends T> var = SkriptParser.parseVariable(this.expr, types);
                if (var != null) {
                    if ((this.flags & 1) == 0) {
                        Skript.error("Variables cannot be used here.");
                        log.printError();
                        Expression<? extends T> expression = null;
                        return expression;
                    }
                    log.printLog();
                    Variable<? extends T> variable = var;
                    return variable;
                }
                if (log.hasError()) {
                    log.printError();
                    Expression<? extends T> expression = null;
                    return expression;
                }
                Class<? extends T>[] fr = this.parseFunction(types);
                if (fr != null) {
                    log.printLog();
                    ExprFunctionCall<? extends T> exprFunctionCall = new ExprFunctionCall<T>(fr);
                    return exprFunctionCall;
                }
                if (log.hasError()) {
                    log.printError();
                    Expression<? extends T> expression = null;
                    return expression;
                }
            }
            log.clear();
            if ((this.flags & 1) != 0) {
                e = this.expr.startsWith("\"") && this.expr.length() != 1 && SkriptParser.nextQuote(this.expr, 1) == this.expr.length() - 1 && (types[0] == Object.class || CollectionUtils.contains(types, String.class)) ? VariableString.newInstance("" + this.expr.substring(1, this.expr.length() - 1)) : (Expression)SkriptParser.parse(this.expr, Skript.getExpressions(types), null);
                if (e != null) {
                    for (Class<T> clazz : types) {
                        if (!clazz.isAssignableFrom(e.getReturnType())) continue;
                        log.printLog();
                        Expression<String> expression = e;
                        return expression;
                    }
                    Class<? extends T>[] objTypes = types;
                    Expression<? extends T> r = e.getConvertedExpression(objTypes);
                    if (r != null) {
                        log.printLog();
                        Expression<? extends T> expression = r;
                        return expression;
                    }
                    log.printError(e.toString(null, false) + " " + Language.get("is") + " " + SkriptParser.notOfType(types), ErrorQuality.NOT_AN_EXPRESSION);
                    Expression<? extends T> expression = null;
                    return expression;
                }
                log.clear();
            }
            if ((this.flags & 2) == 0) {
                log.printError();
                e = null;
                return e;
            }
            if (types[0] == Object.class) {
                if (!allowUnparsedLiteral) {
                    log.printError();
                    e = null;
                    return e;
                }
                log.clear();
                log.printLog();
                e = log.getError();
                UnparsedLiteral unparsedLiteral = new UnparsedLiteral(this.expr, (LogEntry)(e != null && (error == null || ((LogEntry)((Object)e)).quality > error.quality) ? e : error));
                return unparsedLiteral;
            }
            for (Class<? extends T> c : types) {
                log.clear();
                assert (c != null);
                T t = Classes.parse(this.expr, c, this.context);
                if (t == null) continue;
                log.printLog();
                SimpleLiteral<T> simpleLiteral = new SimpleLiteral<T>(t, false);
                return simpleLiteral;
            }
            log.printError();
            Class<? extends T>[] classArray = null;
            return classArray;
        }
        finally {
            log.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final Expression<?> parseSingleExpr(boolean allowUnparsedLiteral, @Nullable LogEntry error, ExprInfo vi) {
        if (this.expr.isEmpty()) {
            return null;
        }
        if (this.context != ParseContext.COMMAND && this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
            return new SkriptParser(this, "" + this.expr.substring(1, this.expr.length() - 1)).parseSingleExpr(allowUnparsedLiteral, error, vi);
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            Expression<String> e;
            Class[] types = new Class[vi.classes.length];
            boolean hasSingular = false;
            boolean hasPlural = false;
            Class[] nonNullTypes = new Class[vi.classes.length];
            int nonNullIndex = 0;
            for (int i = 0; i < types.length; ++i) {
                if ((this.flags & vi.flagMask) == 0) continue;
                if (vi.isPlural[i]) {
                    hasPlural = true;
                } else {
                    hasSingular = true;
                }
                types[i] = vi.classes[i].getC();
                nonNullTypes[nonNullIndex] = types[i];
                ++nonNullIndex;
            }
            boolean onlyPlural = false;
            boolean onlySingular = false;
            if (hasSingular && !hasPlural) {
                onlySingular = true;
            } else if (!hasSingular && hasPlural) {
                onlyPlural = true;
            }
            if (this.context == ParseContext.DEFAULT || this.context == ParseContext.EVENT) {
                Variable var;
                if (onlySingular || onlyPlural) {
                    var = SkriptParser.parseVariable(this.expr, nonNullTypes);
                    if (var != null) {
                        if ((this.flags & 1) == 0) {
                            Skript.error("Variables cannot be used here.");
                            log.printError();
                            Expression<?> expression = null;
                            return expression;
                        }
                        if (hasSingular && !var.isSingle()) {
                            Skript.error("'" + this.expr + "' can only accept a single value of any type, not more", ErrorQuality.SEMANTIC_ERROR);
                            Expression<?> expression = null;
                            return expression;
                        }
                        log.printLog();
                        Variable variable = var;
                        return variable;
                    }
                    if (log.hasError()) {
                        log.printError();
                        Expression<?> expression = null;
                        return expression;
                    }
                } else {
                    var = SkriptParser.parseVariable(this.expr, types);
                    if (var != null) {
                        if ((this.flags & 1) == 0) {
                            Skript.error("Variables cannot be used here.");
                            log.printError();
                            Expression<?> expression = null;
                            return expression;
                        }
                        if ((vi.classes.length == 1 && !vi.isPlural[0] || Booleans.contains((boolean[])vi.isPlural, (boolean)true)) && !var.isSingle()) {
                            Skript.error("'" + this.expr + "' can only accept a single " + Classes.toString(Stream.of(vi.classes).map(ci -> ci.getName().toString()).toArray(), false) + ", not more", ErrorQuality.SEMANTIC_ERROR);
                            Expression<?> expression = null;
                            return expression;
                        }
                        log.printLog();
                        Variable variable = var;
                        return variable;
                    }
                    if (log.hasError()) {
                        log.printError();
                        Expression<?> expression = null;
                        return expression;
                    }
                }
                FunctionReference fr = this.parseFunction(types);
                if (fr != null) {
                    log.printLog();
                    ExprFunctionCall exprFunctionCall = new ExprFunctionCall(fr);
                    return exprFunctionCall;
                }
                if (log.hasError()) {
                    log.printError();
                    Expression<?> expression = null;
                    return expression;
                }
            }
            log.clear();
            if ((this.flags & 1) != 0) {
                e = this.expr.startsWith("\"") && this.expr.length() != 1 && SkriptParser.nextQuote(this.expr, 1) == this.expr.length() - 1 && (types[0] == Object.class || CollectionUtils.contains(types, String.class)) ? VariableString.newInstance("" + this.expr.substring(1, this.expr.length() - 1)) : (Expression)SkriptParser.parse(this.expr, Skript.getExpressions(types), null);
                if (e != null) {
                    Object t;
                    Class returnType = e.getReturnType();
                    assert (returnType != null);
                    for (int i = 0; i < types.length; ++i) {
                        t = types[i];
                        if (t == null || !((Class)t).isAssignableFrom(returnType)) continue;
                        if (!vi.isPlural[i] && !e.isSingle()) {
                            if (this.context == ParseContext.COMMAND) {
                                Skript.error(Commands.m_too_many_arguments.toString(vi.classes[i].getName().getIndefiniteArticle(), vi.classes[i].getName().toString()), ErrorQuality.SEMANTIC_ERROR);
                                Expression<?> expression = null;
                                return expression;
                            }
                            Skript.error("'" + this.expr + "' can only accept a single " + vi.classes[i].getName() + ", not more", ErrorQuality.SEMANTIC_ERROR);
                            Expression<?> expression = null;
                            return expression;
                        }
                        log.printLog();
                        Expression<String> expression = e;
                        return expression;
                    }
                    if (onlySingular && !e.isSingle()) {
                        Skript.error("'" + this.expr + "' can only accept singular expressions, not plural", ErrorQuality.SEMANTIC_ERROR);
                        Expression<?> i = null;
                        return i;
                    }
                    Expression r = e.getConvertedExpression(types);
                    if (r != null) {
                        log.printLog();
                        t = r;
                        return t;
                    }
                    log.printError(e.toString(null, false) + " " + Language.get("is") + " " + SkriptParser.notOfType(types), ErrorQuality.NOT_AN_EXPRESSION);
                    t = null;
                    return t;
                }
                log.clear();
            }
            if ((this.flags & 2) == 0) {
                log.printError();
                e = null;
                return e;
            }
            if (vi.classes[0].getC() == Object.class) {
                if (!allowUnparsedLiteral) {
                    log.printError();
                    e = null;
                    return e;
                }
                log.clear();
                log.printLog();
                e = log.getError();
                UnparsedLiteral unparsedLiteral = new UnparsedLiteral(this.expr, (LogEntry)(e != null && (error == null || ((LogEntry)((Object)e)).quality > error.quality) ? e : error));
                return unparsedLiteral;
            }
            for (ClassInfo<?> ci2 : vi.classes) {
                log.clear();
                assert (ci2.getC() != null);
                Object t = Classes.parse(this.expr, ci2.getC(), this.context);
                if (t == null) continue;
                log.printLog();
                SimpleLiteral simpleLiteral = new SimpleLiteral(t, false, new UnparsedLiteral(this.expr));
                return simpleLiteral;
            }
            log.printError();
            ClassInfo<?>[] classInfoArray = null;
            return classInfoArray;
        }
        finally {
            log.stop();
        }
    }

    private SkriptParser suppressMissingAndOrWarnings() {
        this.suppressMissingAndOrWarnings = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T> Expression<? extends T> parseExpression(Class<? extends T> ... types) {
        if (this.expr.length() == 0) {
            return null;
        }
        assert (types != null && types.length > 0);
        assert (types.length == 1 || !CollectionUtils.contains(types, Object.class));
        boolean isObject = types.length == 1 && types[0] == Object.class;
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            int a2;
            Expression<? extends T> r;
            Class[] cs;
            if (isObject && (this.flags & 2) != 0) {
                SkriptParser p = new SkriptParser(this.expr, 2, this.context);
                if (SkriptParser.getParser().getCurrentScript() != null) {
                    cs = SkriptParser.getParser().getCurrentScript();
                    p.suppressMissingAndOrWarnings = ScriptOptions.getInstance().suppressesWarning(cs.getFile(), "conjunction");
                }
                if (!p.suppressMissingAndOrWarnings) {
                    p.suppressMissingAndOrWarnings = this.suppressMissingAndOrWarnings;
                }
                for (Class c : new Class[]{Number.class, Time.class, ItemType.class, ItemStack.class}) {
                    Expression<T> e = p.parseExpression(c);
                    if (e != null) {
                        log.printLog();
                        Expression<T> expression = e;
                        return expression;
                    }
                    log.clear();
                }
            }
            if ((r = this.parseSingleExpr(false, null, types)) != null) {
                log.printLog();
                cs = r;
                return cs;
            }
            log.clear();
            ArrayList<Expression<? extends T>> ts = new ArrayList<Expression<? extends T>>();
            Kleenean and = Kleenean.UNKNOWN;
            boolean isLiteralList = true;
            ArrayList<int[]> pieces = new ArrayList<int[]>();
            Expression<? extends T> m = listSplitPattern.matcher(this.expr);
            int i = 0;
            int j = 0;
            while (i >= 0 && i <= this.expr.length()) {
                if (i == this.expr.length() || ((Matcher)((Object)m)).region(i, this.expr.length()).lookingAt()) {
                    pieces.add(new int[]{j, i});
                    if (i == this.expr.length()) break;
                    j = i = ((Matcher)((Object)m)).end();
                }
                i = SkriptParser.next(this.expr, i, this.context);
            }
            if (i != this.expr.length()) {
                assert (i == -1 && this.context != ParseContext.COMMAND) : i + "; " + this.expr;
                log.printError("Invalid brackets/variables/text in '" + this.expr + "'", ErrorQuality.NOT_AN_EXPRESSION);
                Expression<? extends T> expression = null;
                return expression;
            }
            if (pieces.size() == 1) {
                if (this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
                    log.clear();
                    log.printLog();
                    m = new SkriptParser(this, "" + this.expr.substring(1, this.expr.length() - 1)).parseExpression(types);
                    return m;
                }
                if (isObject && (this.flags & 2) != 0) {
                    log.clear();
                    log.printLog();
                    m = new UnparsedLiteral(this.expr, log.getError());
                    return m;
                }
                log.printError();
                m = null;
                return m;
            }
            block14: for (int b = 0; b < pieces.size(); b += a2) {
                for (a2 = pieces.size() - b; a2 >= 1; --a2) {
                    String d;
                    if (b == 0 && a2 == pieces.size()) continue;
                    int x = ((int[])pieces.get(b))[0];
                    int y = ((int[])pieces.get(b + a2 - 1))[1];
                    String subExpr = "" + this.expr.substring(x, y).trim();
                    assert (subExpr.length() < this.expr.length()) : subExpr;
                    Expression<? extends T> t = subExpr.startsWith("(") && subExpr.endsWith(")") && SkriptParser.next(subExpr, 0, this.context) == subExpr.length() ? new SkriptParser(this, subExpr).parseExpression(types) : new SkriptParser(this, subExpr).parseSingleExpr(a2 == 1, log.getError(), types);
                    if (t == null) continue;
                    isLiteralList &= t instanceof Literal;
                    ts.add(t);
                    if (b == 0 || (d = this.expr.substring(((int[])pieces.get(b - 1))[1], x).trim()).equals(",")) continue block14;
                    if (and.isUnknown()) {
                        and = Kleenean.get(!d.equalsIgnoreCase("or"));
                        continue block14;
                    }
                    if (and == Kleenean.get(!d.equalsIgnoreCase("or"))) continue block14;
                    Skript.warning("List has multiple 'and' or 'or', will default to 'and'. Use brackets if you want to define multiple lists. List: " + this.expr);
                    and = Kleenean.TRUE;
                    continue block14;
                }
                log.printError();
                Expression<? extends T> a2 = null;
                return a2;
            }
            log.printLog();
            if (ts.size() == 1) {
                Expression b = (Expression)ts.get(0);
                return b;
            }
            if (and.isUnknown() && !this.suppressMissingAndOrWarnings) {
                if (SkriptParser.getParser().getCurrentScript() != null) {
                    Config cs2 = SkriptParser.getParser().getCurrentScript();
                    if (!ScriptOptions.getInstance().suppressesWarning(cs2.getFile(), "conjunction")) {
                        Skript.warning("List is missing 'and' or 'or', defaulting to 'and': " + this.expr);
                    }
                } else {
                    Skript.warning("List is missing 'and' or 'or', defaulting to 'and': " + this.expr);
                }
            }
            Class[] exprRetTypes = new Class[ts.size()];
            for (i = 0; i < ts.size(); ++i) {
                exprRetTypes[i] = ((Expression)ts.get(i)).getReturnType();
            }
            if (isLiteralList) {
                Literal[] ls = ts.toArray(new Literal[ts.size()]);
                assert (ls != null);
                LiteralList literalList = new LiteralList(ls, Utils.getSuperType(exprRetTypes), !and.isFalse());
                return literalList;
            }
            Expression[] es = ts.toArray(new Expression[ts.size()]);
            assert (es != null);
            ExpressionList expressionList = new ExpressionList(es, Utils.getSuperType(exprRetTypes), !and.isFalse());
            return expressionList;
        }
        finally {
            log.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Expression<?> parseExpression(ExprInfo vi) {
        if (this.expr.length() == 0) {
            return null;
        }
        boolean isObject = vi.classes.length == 1 && vi.classes[0].getC() == Object.class;
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            int a2;
            Expression<?> r;
            Class[] cs;
            if (isObject && (this.flags & 2) != 0) {
                SkriptParser p = new SkriptParser(this.expr, 2, this.context);
                p.suppressMissingAndOrWarnings = this.suppressMissingAndOrWarnings;
                if (SkriptParser.getParser().getCurrentScript() != null) {
                    cs = SkriptParser.getParser().getCurrentScript();
                    p.suppressMissingAndOrWarnings = ScriptOptions.getInstance().suppressesWarning(cs.getFile(), "conjunction");
                }
                for (Class c : new Class[]{Number.class, Time.class, ItemType.class, ItemStack.class}) {
                    Expression e = p.parseExpression(c);
                    if (e != null) {
                        log.printLog();
                        Expression expression = e;
                        return expression;
                    }
                    log.clear();
                }
            }
            if ((r = this.parseSingleExpr(false, null, vi)) != null) {
                log.printLog();
                cs = r;
                return cs;
            }
            log.clear();
            ArrayList ts = new ArrayList();
            Kleenean and = Kleenean.UNKNOWN;
            boolean isLiteralList = true;
            ArrayList<int[]> pieces = new ArrayList<int[]>();
            Expression<?> m = listSplitPattern.matcher(this.expr);
            int i = 0;
            int j = 0;
            while (i >= 0 && i <= this.expr.length()) {
                if (i == this.expr.length() || ((Matcher)((Object)m)).region(i, this.expr.length()).lookingAt()) {
                    pieces.add(new int[]{j, i});
                    if (i == this.expr.length()) break;
                    j = i = ((Matcher)((Object)m)).end();
                }
                i = SkriptParser.next(this.expr, i, this.context);
            }
            if (i != this.expr.length()) {
                assert (i == -1 && this.context != ParseContext.COMMAND) : i + "; " + this.expr;
                log.printError("Invalid brackets/variables/text in '" + this.expr + "'", ErrorQuality.NOT_AN_EXPRESSION);
                Expression<?> expression = null;
                return expression;
            }
            if (pieces.size() == 1) {
                if (this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
                    log.clear();
                    log.printLog();
                    m = new SkriptParser(this, "" + this.expr.substring(1, this.expr.length() - 1)).parseExpression(vi);
                    return m;
                }
                if (isObject && (this.flags & 2) != 0) {
                    log.clear();
                    log.printLog();
                    m = new UnparsedLiteral(this.expr, log.getError());
                    return m;
                }
                log.printError();
                m = null;
                return m;
            }
            block15: for (int b = 0; b < pieces.size(); b += a2) {
                for (a2 = pieces.size() - b; a2 >= 1; --a2) {
                    String d;
                    if (b == 0 && a2 == pieces.size()) continue;
                    int x = ((int[])pieces.get(b))[0];
                    int y = ((int[])pieces.get(b + a2 - 1))[1];
                    String subExpr = "" + this.expr.substring(x, y).trim();
                    assert (subExpr.length() < this.expr.length()) : subExpr;
                    Expression<?> t = subExpr.startsWith("(") && subExpr.endsWith(")") && SkriptParser.next(subExpr, 0, this.context) == subExpr.length() ? new SkriptParser(this, subExpr).parseExpression(vi) : new SkriptParser(this, subExpr).parseSingleExpr(a2 == 1, log.getError(), vi);
                    if (t == null) continue;
                    isLiteralList &= t instanceof Literal;
                    ts.add(t);
                    if (b == 0 || (d = this.expr.substring(((int[])pieces.get(b - 1))[1], x).trim()).equals(",")) continue block15;
                    if (and.isUnknown()) {
                        and = Kleenean.get(!d.equalsIgnoreCase("or"));
                        continue block15;
                    }
                    if (and == Kleenean.get(!d.equalsIgnoreCase("or"))) continue block15;
                    Skript.warning("List has multiple 'and' or 'or', will default to 'and'. Use brackets if you want to define multiple lists. List: " + this.expr);
                    and = Kleenean.TRUE;
                    continue block15;
                }
                log.printError();
                Expression<?> a2 = null;
                return a2;
            }
            if (!vi.isPlural[0] && !and.isFalse()) {
                log.printError();
                Expression<?> b = null;
                return b;
            }
            log.printLog();
            if (ts.size() == 1) {
                Expression b = (Expression)ts.get(0);
                return b;
            }
            if (and.isUnknown() && !this.suppressMissingAndOrWarnings) {
                if (SkriptParser.getParser().getCurrentScript() != null) {
                    Config cs2 = SkriptParser.getParser().getCurrentScript();
                    if (!ScriptOptions.getInstance().suppressesWarning(cs2.getFile(), "conjunction")) {
                        Skript.warning("List is missing 'and' or 'or', defaulting to 'and': " + this.expr);
                    }
                } else {
                    Skript.warning("List is missing 'and' or 'or', defaulting to 'and': " + this.expr);
                }
            }
            Class[] exprRetTypes = new Class[ts.size()];
            for (i = 0; i < ts.size(); ++i) {
                exprRetTypes[i] = ((Expression)ts.get(i)).getReturnType();
            }
            if (isLiteralList) {
                Literal[] ls = ts.toArray(new Literal[ts.size()]);
                assert (ls != null);
                LiteralList literalList = new LiteralList(ls, Utils.getSuperType(exprRetTypes), !and.isFalse());
                return literalList;
            }
            Expression[] es = ts.toArray(new Expression[ts.size()]);
            assert (es != null);
            ExpressionList expressionList = new ExpressionList(es, Utils.getSuperType(exprRetTypes), !and.isFalse());
            return expressionList;
        }
        finally {
            log.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T> FunctionReference<T> parseFunction(Class<? extends T> ... types) {
        if (this.context != ParseContext.DEFAULT && this.context != ParseContext.EVENT) {
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            Expression[] params;
            Matcher m = functionCallPattern.matcher(this.expr);
            if (!m.matches()) {
                log.printLog();
                FunctionReference<T> functionReference = null;
                return functionReference;
            }
            String functionName = "" + m.group(1);
            String args = m.group(2);
            int level = 0;
            for (char c : args.toCharArray()) {
                if (c == '(') {
                    ++level;
                    continue;
                }
                if (c != ')') continue;
                if (level == 0) {
                    log.printLog();
                    FunctionReference<T> functionReference = null;
                    return functionReference;
                }
                --level;
            }
            if ((this.flags & 1) == 0) {
                Skript.error("Functions cannot be used here (or there is a problem with your arguments).");
                log.printError();
                char[] cArray = null;
                return cArray;
            }
            if (args.length() != 0) {
                Expression<T> ps = new SkriptParser(args, this.flags | 2, this.context).suppressMissingAndOrWarnings().parseExpression(Object.class);
                if (ps == null) {
                    log.printError();
                    FunctionReference<T> functionReference = null;
                    return functionReference;
                }
                if (ps instanceof ExpressionList) {
                    if (!ps.getAnd()) {
                        Skript.error("Function arguments must be separated by commas and optionally an 'and', but not an 'or'. Put the 'or' into a second set of parentheses if you want to make it a single parameter, e.g. 'give(player, (sword or axe))'");
                        log.printError();
                        FunctionReference<T> functionReference = null;
                        return functionReference;
                    }
                    params = ((ExpressionList)ps).getExpressions();
                } else {
                    params = new Expression[]{ps};
                }
            } else {
                params = new Expression[]{};
            }
            FunctionReference<T> e = new FunctionReference<T>(functionName, SkriptLogger.getNode(), SkriptParser.getParser().getCurrentScript() != null ? SkriptParser.getParser().getCurrentScript().getFileName() : null, types, params);
            if (!e.validateFunction(true)) {
                log.printError();
                FunctionReference<T> functionReference = null;
                return functionReference;
            }
            log.printLog();
            FunctionReference<T> functionReference = e;
            return functionReference;
        }
        finally {
            log.stop();
        }
    }

    public static boolean parseArguments(String args, ScriptCommand command, ScriptCommandEvent event) {
        SkriptParser parser = new SkriptParser(args, 2, ParseContext.COMMAND);
        ParseResult res = parser.parse_i(command.getPattern(), 0, 0);
        if (res == null) {
            return false;
        }
        List<Argument<?>> as = command.getArguments();
        assert (as.size() == res.exprs.length);
        for (int i = 0; i < res.exprs.length; ++i) {
            if (res.exprs[i] == null) {
                as.get(i).setToDefault(event);
                continue;
            }
            as.get(i).set(event, res.exprs[i].getArray(event));
        }
        return true;
    }

    @Nullable
    public static ParseResult parse(String text, String pattern) {
        return new SkriptParser(text, 2, ParseContext.COMMAND).parse_i(pattern, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static NonNullPair<SkriptEventInfo<?>, SkriptEvent> parseEvent(String event, String defaultError) {
        RetainingLogHandler log = SkriptLogger.startRetainingLog();
        try {
            EventPriority priority;
            String[] split = event.split(" with priority ");
            if (split.length != 1) {
                event = String.join((CharSequence)" with priority ", Arrays.copyOfRange(split, 0, split.length - 1));
                String priorityString = split[split.length - 1];
                try {
                    priority = EventPriority.valueOf((String)priorityString.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    log.printErrors("The priority " + priorityString + " doesn't exist");
                    NonNullPair<SkriptEventInfo<?>, SkriptEvent> nonNullPair = null;
                    log.stop();
                    return nonNullPair;
                }
            } else {
                priority = null;
            }
            NonNullPair<SkriptEventInfo<?>, SkriptEvent> e = new SkriptParser(event, 2, ParseContext.EVENT).parseEvent();
            if (e != null) {
                if (priority != null && e.getSecond() instanceof SelfRegisteringSkriptEvent) {
                    log.printErrors("This event doesn't support event priority");
                    NonNullPair<SkriptEventInfo<?>, SkriptEvent> nonNullPair = null;
                    return nonNullPair;
                }
                e.getSecond().eventPriority = priority;
                log.printLog();
                NonNullPair<SkriptEventInfo<?>, SkriptEvent> nonNullPair = e;
                return nonNullPair;
            }
            log.printErrors(defaultError);
            NonNullPair<SkriptEventInfo<?>, SkriptEvent> nonNullPair = null;
            return nonNullPair;
        }
        finally {
            log.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private NonNullPair<SkriptEventInfo<?>, SkriptEvent> parseEvent() {
        assert (this.context == ParseContext.EVENT);
        assert (this.flags == 2);
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            Iterator<SkriptEventInfo<?>> iterator = Skript.getEvents().iterator();
            block7: while (true) {
                if (!iterator.hasNext()) {
                    log.printError(null);
                    iterator = null;
                    log.stop();
                    return iterator;
                }
                SkriptEventInfo<?> info = iterator.next();
                int i = 0;
                while (true) {
                    block15: {
                        NonNullPair nonNullPair;
                        SkriptEvent e;
                        block16: {
                            if (i >= info.patterns.length) continue block7;
                            log.clear();
                            String pattern = info.patterns[i];
                            assert (pattern != null);
                            ParseResult res = this.parse_i(pattern, 0, 0);
                            if (res == null) break block15;
                            e = (SkriptEvent)info.c.newInstance();
                            Literal[] ls = (Literal[])Arrays.copyOf(res.exprs, res.exprs.length, Literal[].class);
                            assert (ls != null);
                            if (e.init(ls, i, res)) break block16;
                            log.printError();
                            NonNullPair<SkriptEventInfo<?>, SkriptEvent> nonNullPair2 = null;
                            log.stop();
                            return nonNullPair2;
                        }
                        try {
                            log.printLog();
                            nonNullPair = new NonNullPair(info, e);
                        }
                        catch (InstantiationException e2) {
                            assert (false);
                            break block15;
                        }
                        catch (IllegalAccessException e3) {
                            if ($assertionsDisabled) break block15;
                            throw new AssertionError();
                        }
                        log.stop();
                        return nonNullPair;
                    }
                    ++i;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            log.stop();
            throw throwable;
        }
    }

    private static int nextBracket(String pattern, char closingBracket, char openingBracket, int start, boolean isGroup) throws MalformedPatternException {
        int n = 0;
        for (int i = start; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (pattern.charAt(i) == closingBracket) {
                if (n == 0) {
                    if (!isGroup) {
                        throw new MalformedPatternException(pattern, "Unexpected closing bracket '" + closingBracket + "'");
                    }
                    return i;
                }
                --n;
                continue;
            }
            if (pattern.charAt(i) != openingBracket) continue;
            ++n;
        }
        if (isGroup) {
            throw new MalformedPatternException(pattern, "Missing closing bracket '" + closingBracket + "'");
        }
        return -1;
    }

    private static int nextUnescaped(String pattern, char c, int from) {
        for (int i = from; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (pattern.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    static int countUnescaped(String pattern, char c) {
        return SkriptParser.countUnescaped(pattern, c, 0, pattern.length());
    }

    static int countUnescaped(String pattern, char c, int start, int end) {
        assert (start >= 0 && start <= end && end <= pattern.length()) : start + ", " + end + "; " + pattern.length();
        int r = 0;
        for (int i = start; i < end; ++i) {
            char x = pattern.charAt(i);
            if (x == '\\') {
                ++i;
                continue;
            }
            if (x != c) continue;
            ++r;
        }
        return r;
    }

    private static int nextQuote(String s, int from) {
        boolean inExpression = false;
        for (int i = from; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"' && !inExpression) {
                if (i == s.length() - 1 || s.charAt(i + 1) != '\"') {
                    return i;
                }
                ++i;
                continue;
            }
            if (c != '%') continue;
            inExpression = !inExpression;
        }
        return -1;
    }

    public static String notOfType(Class<?> ... cs) {
        if (cs.length == 1) {
            Class<?> c = cs[0];
            assert (c != null);
            return Language.get("not") + " " + Classes.getSuperClassInfo(c).getName().withIndefiniteArticle();
        }
        StringBuilder b = new StringBuilder(Language.get("neither") + " ");
        for (int k = 0; k < cs.length; ++k) {
            if (k != 0) {
                if (k != cs.length - 1) {
                    b.append(", ");
                } else {
                    b.append(" " + Language.get("nor") + " ");
                }
            }
            Class<?> c = cs[k];
            assert (c != null);
            b.append(Classes.getSuperClassInfo(c).getName().withIndefiniteArticle());
        }
        return "" + b.toString();
    }

    public static String notOfType(ClassInfo<?> ... cs) {
        if (cs.length == 1) {
            return Language.get("not") + " " + cs[0].getName().withIndefiniteArticle();
        }
        StringBuilder b = new StringBuilder(Language.get("neither") + " ");
        for (int k = 0; k < cs.length; ++k) {
            if (k != 0) {
                if (k != cs.length - 1) {
                    b.append(", ");
                } else {
                    b.append(" " + Language.get("nor") + " ");
                }
            }
            b.append(cs[k].getName().withIndefiniteArticle());
        }
        return "" + b.toString();
    }

    public static int next(String expr, int i, ParseContext context) {
        if (i >= expr.length()) {
            return -1;
        }
        if (i < 0) {
            throw new StringIndexOutOfBoundsException(i);
        }
        if (context == ParseContext.COMMAND) {
            return i + 1;
        }
        char c = expr.charAt(i);
        if (c == '\"') {
            int i2 = SkriptParser.nextQuote(expr, i + 1);
            return i2 < 0 ? -1 : i2 + 1;
        }
        if (c == '{') {
            int i2 = VariableString.nextVariableBracket(expr, i + 1);
            return i2 < 0 ? -1 : i2 + 1;
        }
        if (c == '(') {
            int j = i + 1;
            while (j >= 0 && j < expr.length()) {
                if (expr.charAt(j) == ')') {
                    return j + 1;
                }
                j = SkriptParser.next(expr, j, context);
            }
            return -1;
        }
        return i + 1;
    }

    private static int getGroupLevel(String pattern, int j) {
        assert (j >= 0 && j <= pattern.length()) : j + "; " + pattern;
        int level = 0;
        for (int i = 0; i < j; ++i) {
            char c = pattern.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (c == '(') {
                ++level;
                continue;
            }
            if (c != ')') continue;
            if (level == 0) {
                throw new MalformedPatternException(pattern, "Unexpected closing bracket ')'");
            }
            --level;
        }
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private final ParseResult parse_i(String pattern, int i, int j) {
        block41: while (true) {
            if (j >= pattern.length()) {
                if (i != this.expr.length()) return null;
                if (j != pattern.length()) return null;
                return new ParseResult(this, pattern);
            }
            switch (pattern.charAt(j)) {
                case '[': {
                    ParseLogHandler log = SkriptLogger.startParseLogHandler();
                    try {
                        ParseResult res = this.parse_i(pattern, i, j + 1);
                        if (res != null) {
                            log.printLog();
                            ParseResult parseResult = res;
                            return parseResult;
                        }
                        log.clear();
                        j = SkriptParser.nextBracket(pattern, ']', '[', j + 1, true) + 1;
                        res = this.parse_i(pattern, i, j);
                        if (res == null) {
                            log.printError();
                        } else {
                            log.printLog();
                        }
                        ParseResult parseResult = res;
                        return parseResult;
                    }
                    finally {
                        log.stop();
                    }
                }
                case '(': {
                    ParseLogHandler log = SkriptLogger.startParseLogHandler();
                    try {
                        int start = j;
                        while (j < pattern.length()) {
                            log.clear();
                            if (j == start || pattern.charAt(j) == '|') {
                                ParseResult res;
                                int j22;
                                int mark = 0;
                                if (j != pattern.length() - 1 && ('0' <= pattern.charAt(j + 1) && pattern.charAt(j + 1) <= '9' || pattern.charAt(j + 1) == '-') && (j22 = pattern.indexOf(166, j + 2)) != -1) {
                                    try {
                                        mark = Integer.parseInt(pattern.substring(j + 1, j22));
                                        j = j22;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                if ((res = this.parse_i(pattern, i, j + 1)) != null) {
                                    log.printLog();
                                    res.mark ^= mark;
                                    ParseResult j22 = res;
                                    return j22;
                                }
                            } else if (pattern.charAt(j) == '(') {
                                j = SkriptParser.nextBracket(pattern, ')', '(', j + 1, true);
                            } else {
                                if (pattern.charAt(j) == ')') break;
                                if (j == pattern.length() - 1) {
                                    throw new MalformedPatternException(pattern, "Missing closing bracket ')'");
                                }
                            }
                            ++j;
                        }
                        log.printError();
                        ParseResult mark = null;
                        return mark;
                    }
                    finally {
                        log.stop();
                    }
                }
                case '%': {
                    int i2;
                    if (i == this.expr.length()) {
                        return null;
                    }
                    int end = pattern.indexOf(37, j + 1);
                    if (end == -1) {
                        throw new MalformedPatternException(pattern, "Odd number of '%'");
                    }
                    String name = "" + pattern.substring(j + 1, end);
                    ExprInfo vi = SkriptParser.getExprInfo(name);
                    if (end == pattern.length() - 1) {
                        i2 = this.expr.length();
                    } else {
                        i2 = SkriptParser.next(this.expr, i, this.context);
                        if (i2 == -1) {
                            return null;
                        }
                    }
                    ParseLogHandler log = SkriptLogger.startParseLogHandler();
                    try {
                        while (i2 != -1) {
                            log.clear();
                            ParseResult res = this.parse_i(pattern, i2, end + 1);
                            if (res != null) {
                                ParseLogHandler log2 = SkriptLogger.startParseLogHandler();
                                try {
                                    Expression<?> e = new SkriptParser("" + this.expr.substring(i, i2), this.flags & vi.flagMask, this.context).parseExpression(vi);
                                    if (e != null) {
                                        if (vi.time != 0) {
                                            if (e instanceof Literal) {
                                                ParseResult parseResult = null;
                                                return parseResult;
                                            }
                                            if (SkriptParser.getParser().getHasDelayBefore() == Kleenean.TRUE) {
                                                Skript.error("Cannot use time states after the event has already passed", ErrorQuality.SEMANTIC_ERROR);
                                                ParseResult parseResult = null;
                                                return parseResult;
                                            }
                                            if (!e.setTime(vi.time)) {
                                                Skript.error(e + " does not have a " + (vi.time == -1 ? "past" : "future") + " state", ErrorQuality.SEMANTIC_ERROR);
                                                ParseResult parseResult = null;
                                                return parseResult;
                                            }
                                        }
                                        log2.printLog();
                                        log.printLog();
                                        res.exprs[SkriptParser.countUnescaped((String)pattern, (char)'%', (int)0, (int)j) / 2] = e;
                                        ParseResult parseResult = res;
                                        return parseResult;
                                    }
                                    ParseResult parseResult = null;
                                    return parseResult;
                                }
                                finally {
                                    log2.printError();
                                }
                            }
                            i2 = SkriptParser.next(this.expr, i2, this.context);
                        }
                        return null;
                    }
                    finally {
                        if (!log.isStopped()) {
                            log.printError();
                        }
                    }
                }
                case '<': {
                    Pattern p;
                    int end = pattern.indexOf(62, j + 1);
                    if (end == -1) {
                        throw new MalformedPatternException(pattern, "Missing closing regex bracket '>'");
                    }
                    try {
                        p = Pattern.compile(pattern.substring(j + 1, end));
                    }
                    catch (PatternSyntaxException e) {
                        throw new MalformedPatternException(pattern, "Invalid regex <" + pattern.substring(j + 1, end) + ">", e);
                    }
                    ParseLogHandler log = SkriptLogger.startParseLogHandler();
                    try {
                        Matcher m = p.matcher(this.expr);
                        int i2 = SkriptParser.next(this.expr, i, this.context);
                        while (i2 != -1) {
                            ParseResult res;
                            log.clear();
                            m.region(i, i2);
                            if (m.matches() && (res = this.parse_i(pattern, i2, end + 1)) != null) {
                                res.regexes.add(0, m.toMatchResult());
                                log.printLog();
                                ParseResult parseResult = res;
                                return parseResult;
                            }
                            i2 = SkriptParser.next(this.expr, i2, this.context);
                        }
                        log.printError(null);
                        ParseResult parseResult = null;
                        return parseResult;
                    }
                    finally {
                        log.stop();
                    }
                }
                case ')': 
                case ']': {
                    ++j;
                    continue block41;
                }
                case '|': {
                    int newJ = SkriptParser.nextBracket(pattern, ')', '(', j + 1, SkriptParser.getGroupLevel(pattern, j) != 0);
                    if (newJ == -1) {
                        if (i == this.expr.length()) {
                            j = pattern.length();
                            continue block41;
                        }
                        i = 0;
                        ++j;
                        continue block41;
                    }
                    j = newJ + 1;
                    continue block41;
                }
                case ' ': {
                    if (i == 0 || i == this.expr.length() || i > 0 && this.expr.charAt(i - 1) == ' ') {
                        ++j;
                        continue block41;
                    }
                    if (this.expr.charAt(i) != ' ') {
                        return null;
                    }
                    ++i;
                    ++j;
                    continue block41;
                }
                case '\\': {
                    if (++j != pattern.length()) break;
                    throw new MalformedPatternException(pattern, "Must not end with a backslash");
                }
            }
            if (i == this.expr.length()) return null;
            if (Character.toLowerCase(pattern.charAt(j)) != Character.toLowerCase(this.expr.charAt(i))) {
                return null;
            }
            ++i;
            ++j;
        }
    }

    @Nullable
    public static NonNullPair<String, boolean[]> validatePattern(String pattern) {
        ArrayList<Boolean> ps = new ArrayList<Boolean>();
        int groupLevel = 0;
        int optionalLevel = 0;
        LinkedList<Character> groups = new LinkedList<Character>();
        StringBuilder b = new StringBuilder(pattern.length());
        int last = 0;
        for (int i = 0; i < pattern.length(); ++i) {
            int j;
            char c = pattern.charAt(i);
            if (c == '(') {
                ++groupLevel;
                groups.addLast(Character.valueOf(c));
                continue;
            }
            if (c == '|') {
                if (groupLevel == 0 || ((Character)groups.peekLast()).charValue() != '(' && ((Character)groups.peekLast()).charValue() != '|') {
                    return SkriptParser.error("Cannot use the pipe character '|' outside of groups. Escape it if you want to match a literal pipe: '\\|'");
                }
                groups.removeLast();
                groups.addLast(Character.valueOf(c));
                continue;
            }
            if (c == ')') {
                if (groupLevel == 0 || ((Character)groups.peekLast()).charValue() != '(' && ((Character)groups.peekLast()).charValue() != '|') {
                    return SkriptParser.error("Unexpected closing group bracket ')'. Escape it if you want to match a literal bracket: '\\)'");
                }
                if (((Character)groups.peekLast()).charValue() == '(') {
                    return SkriptParser.error("(...|...) groups have to contain at least one pipe character '|' to separate it into parts. Escape the brackets if you want to match literal brackets: \"\\(not a group\\)\"");
                }
                --groupLevel;
                groups.removeLast();
                continue;
            }
            if (c == '[') {
                ++optionalLevel;
                groups.addLast(Character.valueOf(c));
                continue;
            }
            if (c == ']') {
                if (optionalLevel == 0 || ((Character)groups.peekLast()).charValue() != '[') {
                    return SkriptParser.error("Unexpected closing optional bracket ']'. Escape it if you want to match a literal bracket: '\\]'");
                }
                --optionalLevel;
                groups.removeLast();
                continue;
            }
            if (c == '<') {
                j = pattern.indexOf(62, i + 1);
                if (j == -1) {
                    return SkriptParser.error("Missing closing regex bracket '>'. Escape the '<' if you want to match a literal bracket: '\\<'");
                }
                try {
                    Pattern.compile(pattern.substring(i + 1, j));
                }
                catch (PatternSyntaxException e) {
                    return SkriptParser.error("Invalid Regular Expression '" + pattern.substring(i + 1, j) + "': " + e.getLocalizedMessage());
                }
                i = j;
                continue;
            }
            if (c == '>') {
                return SkriptParser.error("Unexpected closing regex bracket '>'. Escape it if you want to match a literal bracket: '\\>'");
            }
            if (c == '%') {
                j = pattern.indexOf(37, i + 1);
                if (j == -1) {
                    return SkriptParser.error("Missing end sign '%' of expression. Escape the percent sign to match a literal '%': '\\%'");
                }
                NonNullPair<String, Boolean> p = Utils.getEnglishPlural("" + pattern.substring(i + 1, j));
                ClassInfo<?> ci = Classes.getClassInfoFromUserInput(p.getFirst());
                if (ci == null) {
                    return SkriptParser.error("The type '" + p.getFirst() + "' could not be found. Please check your spelling or escape the percent signs if you want to match literal %s: \"\\%not an expression\\%\"");
                }
                ps.add(p.getSecond());
                b.append(pattern.substring(last, i + 1));
                b.append(Utils.toEnglishPlural(ci.getCodeName(), p.getSecond()));
                last = j;
                i = j;
                continue;
            }
            if (c != '\\') continue;
            if (i == pattern.length() - 1) {
                return SkriptParser.error("Pattern must not end in an unescaped backslash. Add another backslash to escape it, or remove it altogether.");
            }
            ++i;
        }
        b.append(pattern.substring(last));
        boolean[] plurals = new boolean[ps.size()];
        for (int i = 0; i < plurals.length; ++i) {
            plurals[i] = (Boolean)ps.get(i);
        }
        return new NonNullPair<String, boolean[]>("" + b.toString(), plurals);
    }

    @Nullable
    private static NonNullPair<String, boolean[]> error(String error) {
        Skript.error("Invalid pattern: " + error);
        return null;
    }

    public static boolean validateLine(String line) {
        if (StringUtils.count(line, '\"') % 2 != 0) {
            Skript.error(m_quotes_error.toString());
            return false;
        }
        int i = 0;
        while (i < line.length()) {
            if (i == -1) {
                Skript.error(m_brackets_error.toString());
                return false;
            }
            i = SkriptParser.next(line, i, ParseContext.DEFAULT);
        }
        return true;
    }

    private static ExprInfo getExprInfo(String s) throws MalformedPatternException, IllegalArgumentException, SkriptAPIException {
        ExprInfo r = exprInfoCache.get(s);
        if (r == null) {
            r = SkriptParser.createExprInfo(s);
            exprInfoCache.put(s, r);
        }
        return r;
    }

    private static ExprInfo createExprInfo(String s) throws MalformedPatternException, IllegalArgumentException, SkriptAPIException {
        int a;
        ExprInfo r = new ExprInfo(StringUtils.count(s, '/') + 1);
        r.isOptional = s.startsWith("-");
        if (r.isOptional) {
            s = "" + s.substring(1);
        }
        if (s.startsWith("*")) {
            s = "" + s.substring(1);
            r.flagMask &= 0xFFFFFFFE;
        } else if (s.startsWith("~")) {
            s = "" + s.substring(1);
            r.flagMask &= 0xFFFFFFFD;
        }
        if (!r.isOptional) {
            r.isOptional = s.startsWith("-");
            if (r.isOptional) {
                s = "" + s.substring(1);
            }
        }
        if ((a = s.indexOf("@")) != -1) {
            r.time = Integer.parseInt(s.substring(a + 1));
            s = "" + s.substring(0, a);
        }
        String[] classes = s.split("/");
        assert (classes.length == r.classes.length);
        for (int i = 0; i < classes.length; ++i) {
            NonNullPair<String, Boolean> p = Utils.getEnglishPlural("" + classes[i]);
            r.classes[i] = Classes.getClassInfo(p.getFirst());
            r.isPlural[i] = p.getSecond();
        }
        return r;
    }

    private static ParserInstance getParser() {
        return ParserInstance.get();
    }

    private static final class ExprInfo {
        final ClassInfo<?>[] classes;
        final boolean[] isPlural;
        boolean isOptional;
        int flagMask = -1;
        int time = 0;

        public ExprInfo(int length) {
            this.classes = new ClassInfo[length];
            this.isPlural = new boolean[length];
        }
    }

    private static final class MalformedPatternException
    extends RuntimeException {
        private static final long serialVersionUID = -5133477361763823946L;

        public MalformedPatternException(String pattern, String message) {
            this(pattern, message, null);
        }

        public MalformedPatternException(String pattern, String message, @Nullable Throwable cause) {
            super(message + " [pattern: " + pattern + "]", cause);
        }
    }

    public static final class ParseResult {
        public final Expression<?>[] exprs;
        public final List<MatchResult> regexes = new ArrayList<MatchResult>(1);
        public final String expr;
        public int mark = 0;

        public ParseResult(SkriptParser parser, String pattern) {
            this.expr = parser.expr;
            this.exprs = new Expression[SkriptParser.countUnescaped(pattern, '%') / 2];
        }
    }
}

