/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.config.Config;
import ch.njol.skript.expressions.ExprColoured;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.BlockingLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.ScriptOptions;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.chat.ChatMessages;
import ch.njol.skript.util.chat.MessageComponent;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.util.coll.iterator.SingleItemIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class VariableString
implements Expression<String> {
    private final String orig;
    @Nullable
    private final Object[] string;
    @Nullable
    private Object[] stringUnformatted;
    private final boolean isSimple;
    @Nullable
    private final String simple;
    @Nullable
    private final String simpleUnformatted;
    private final StringMode mode;
    private final MessageComponent[] components;
    public static boolean disableVariableStartingWithExpressionWarnings = false;
    public static final Map<String, Pattern> variableNames = new HashMap<String, Pattern>();

    private VariableString(String s) {
        this.isSimple = true;
        this.simpleUnformatted = s.replace("%%", "%");
        this.orig = this.simple = Utils.replaceChatStyles(this.simpleUnformatted);
        this.string = null;
        this.mode = StringMode.MESSAGE;
        this.components = new MessageComponent[]{ChatMessages.plainText(this.simpleUnformatted)};
    }

    private VariableString(String orig, Object[] string, StringMode mode) {
        this.orig = orig;
        this.string = new Object[string.length];
        this.stringUnformatted = new Object[string.length];
        ArrayList<MessageComponent> components = new ArrayList<MessageComponent>(string.length);
        for (int i = 0; i < string.length; ++i) {
            Object o = string[i];
            if (o instanceof String) {
                this.string[i] = Utils.replaceChatStyles((String)o);
                components.addAll(ChatMessages.parse((String)o));
            } else {
                this.string[i] = o;
                components.add(null);
            }
            this.stringUnformatted[i] = o;
        }
        this.components = components.toArray(new MessageComponent[0]);
        this.mode = mode;
        this.isSimple = false;
        this.simple = null;
        this.simpleUnformatted = null;
    }

    @Nullable
    public static VariableString newInstance(String s) {
        return VariableString.newInstance(s, StringMode.MESSAGE);
    }

    public static boolean isQuotedCorrectly(String s, boolean withQuotes) {
        if (!(!withQuotes || s.startsWith("\"") && s.endsWith("\""))) {
            return false;
        }
        boolean quote = false;
        boolean percentage = false;
        for (int i = withQuotes ? 1 : 0; i < (withQuotes ? s.length() - 1 : s.length()); ++i) {
            if (percentage) {
                if (s.charAt(i) != '%') continue;
                percentage = false;
                continue;
            }
            if (quote && s.charAt(i) != '\"') {
                return false;
            }
            if (s.charAt(i) == '\"') {
                quote = !quote;
                continue;
            }
            if (s.charAt(i) != '%') continue;
            percentage = true;
        }
        return !quote;
    }

    public static String unquote(String s, boolean surroundingQuotes) {
        assert (VariableString.isQuotedCorrectly(s, surroundingQuotes));
        if (surroundingQuotes) {
            return s.substring(1, s.length() - 1).replace("\"\"", "\"");
        }
        return s.replace("\"\"", "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static VariableString newInstance(String orig, StringMode mode) {
        String s;
        if (mode != StringMode.VARIABLE_NAME && !VariableString.isQuotedCorrectly(orig, false)) {
            return null;
        }
        int n = StringUtils.count(orig, '%');
        if (n % 2 != 0) {
            Skript.error("The percent sign is used for expressions (e.g. %player%). To insert a '%' type it twice: %%.");
            return null;
        }
        if (mode != StringMode.VARIABLE_NAME) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean expression = false;
            for (int i = 0; i < orig.length(); ++i) {
                char c = orig.charAt(i);
                stringBuilder.append(c);
                if (c == '%') {
                    boolean bl = expression = !expression;
                }
                if (expression || c != '\"') continue;
                ++i;
            }
            s = stringBuilder.toString();
        } else {
            s = orig;
        }
        ArrayList<Object> string = new ArrayList<Object>(n / 2 + 2);
        int c = s.indexOf(37);
        if (c != -1) {
            if (c != 0) {
                string.add(s.substring(0, c));
            }
            while (c != s.length()) {
                String l;
                int b;
                int c2 = s.indexOf(37, c + 1);
                int a = c;
                while (c2 != -1 && (b = s.indexOf(123, a + 1)) != -1 && b < c2) {
                    a = VariableString.nextVariableBracket(s, b + 1);
                    if (a == -1) {
                        Skript.error("Missing closing bracket '}' to end variable");
                        return null;
                    }
                    c2 = s.indexOf(37, a + 1);
                }
                if (c2 == -1) {
                    assert (false);
                    return null;
                }
                if (c + 1 == c2) {
                    if (string.size() > 0 && string.get(string.size() - 1) instanceof String) {
                        string.set(string.size() - 1, (String)string.get(string.size() - 1) + "%");
                    } else {
                        string.add("%");
                    }
                } else {
                    RetainingLogHandler log = SkriptLogger.startRetainingLog();
                    try {
                        Expression expr = new SkriptParser(s.substring(c + 1, c2), 1, ParseContext.DEFAULT).parseExpression(Object.class);
                        if (expr == null) {
                            log.printErrors("Can't understand this expression: " + s.substring(c + 1, c2));
                            VariableString variableString = null;
                            return variableString;
                        }
                        string.add(expr);
                        log.printLog();
                    }
                    finally {
                        log.stop();
                    }
                }
                c = s.indexOf(37, c2 + 1);
                if (c == -1) {
                    c = s.length();
                }
                if ((l = s.substring(c2 + 1, c)).isEmpty()) continue;
                if (string.size() > 0 && string.get(string.size() - 1) instanceof String) {
                    string.set(string.size() - 1, (String)string.get(string.size() - 1) + l);
                    continue;
                }
                string.add(l);
            }
        } else {
            string.add(s);
        }
        VariableString.checkVariableConflicts(s, mode, string);
        if (string.size() == 1 && string.get(0) instanceof String) {
            return new VariableString(s);
        }
        Object[] sa = string.toArray();
        if (string.size() == 1 && string.get(0) instanceof Expression && ((Expression)string.get(0)).getReturnType() == String.class && ((Expression)string.get(0)).isSingle() && mode == StringMode.MESSAGE) {
            String expr = ((Expression)string.get(0)).toString(null, false);
            Skript.warning(expr + " is already a text, so you should not put it in one (e.g. " + expr + " instead of \"%" + expr.replace("\"", "\"\"") + "%\")");
        }
        return new VariableString(orig, sa, mode);
    }

    private static void checkVariableConflicts(String name, StringMode mode, @Nullable Iterable<Object> string) {
        Pattern pattern;
        Config script;
        ParserInstance parserInstance = ParserInstance.get();
        if (mode != StringMode.VARIABLE_NAME || variableNames.containsKey(name)) {
            return;
        }
        if (name.startsWith("%") && (script = parserInstance.getCurrentScript()) != null && disableVariableStartingWithExpressionWarnings && !ScriptOptions.getInstance().suppressesWarning(script.getFile(), "start expression")) {
            Skript.warning("Starting a variable's name with an expression is discouraged ({" + name + "}). You could prefix it with the script's name: {" + StringUtils.substring(script.getFileName(), 0, -3) + "." + name + "}");
        }
        if (string != null) {
            StringBuilder p = new StringBuilder();
            block0: for (Object object : string) {
                if (object instanceof Expression) {
                    for (ClassInfo<?> ci : Classes.getClassInfos()) {
                        Parser<?> parser = ci.getParser();
                        if (parser == null || !ci.getC().isAssignableFrom(((Expression)object).getReturnType())) continue;
                        p.append("(?!%)").append(parser.getVariableNamePattern()).append("(?<!%)");
                        continue block0;
                    }
                    p.append("[^%*](.*[^%*])?");
                    continue;
                }
                p.append(Pattern.quote(object.toString()));
            }
            pattern = Pattern.compile(p.toString());
        } else {
            pattern = Pattern.compile(Pattern.quote(name));
        }
        if (!SkriptConfig.disableVariableConflictWarnings.value().booleanValue()) {
            Config cs = parserInstance.getCurrentScript();
            if (cs != null) {
                if (!ScriptOptions.getInstance().suppressesWarning(cs.getFile(), "conflict")) {
                    for (Map.Entry entry : variableNames.entrySet()) {
                        if (!((Pattern)entry.getValue()).matcher(name).matches() && !pattern.matcher((CharSequence)entry.getKey()).matches()) continue;
                        Skript.warning("Possible name conflict of variables {" + name + "} and {" + (String)entry.getKey() + "} (there might be more conflicts).");
                        break;
                    }
                }
            } else {
                for (Map.Entry entry : variableNames.entrySet()) {
                    if (!((Pattern)entry.getValue()).matcher(name).matches() && !pattern.matcher((CharSequence)entry.getKey()).matches()) continue;
                    Skript.warning("Possible name conflict of variables {" + name + "} and {" + (String)entry.getKey() + "} (there might be more conflicts).");
                    break;
                }
            }
        }
        variableNames.put(name, pattern);
    }

    public static int nextVariableBracket(String s, int start) {
        int n = 0;
        for (int i = start; i < s.length(); ++i) {
            if (s.charAt(i) == '}') {
                if (n == 0) {
                    return i;
                }
                --n;
                continue;
            }
            if (s.charAt(i) != '{') continue;
            ++n;
        }
        return -1;
    }

    public static VariableString[] makeStrings(String[] args) {
        VariableString[] strings = new VariableString[args.length];
        int j = 0;
        for (String arg : args) {
            VariableString vs = VariableString.newInstance(arg);
            if (vs == null) continue;
            strings[j++] = vs;
        }
        if (j != args.length) {
            strings = Arrays.copyOf(strings, j);
        }
        return strings;
    }

    @Nullable
    public static VariableString[] makeStringsFromQuoted(List<String> args) {
        VariableString[] strings = new VariableString[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            assert (args.get(i).startsWith("\"") && args.get(i).endsWith("\""));
            VariableString vs = VariableString.newInstance(args.get(i).substring(1, args.get(i).length() - 1));
            if (vs == null) {
                return null;
            }
            strings[i] = vs;
        }
        return strings;
    }

    public String toString(@Nullable Event e) {
        if (this.isSimple) {
            assert (this.simple != null);
            return this.simple;
        }
        if (e == null) {
            throw new IllegalArgumentException("Event may not be null in non-simple VariableStrings!");
        }
        Object[] string = this.string;
        assert (string != null);
        StringBuilder b = new StringBuilder();
        for (Object o : string) {
            if (o instanceof Expression) {
                b.append(Classes.toString((Object[])((Expression)o).getArray(e), true, this.mode));
                continue;
            }
            b.append(o);
        }
        return b.toString();
    }

    public String toUnformattedString(Event e) {
        if (this.isSimple) {
            assert (this.simpleUnformatted != null);
            return this.simpleUnformatted;
        }
        Object[] string = this.stringUnformatted;
        assert (string != null);
        StringBuilder b = new StringBuilder();
        for (Object o : string) {
            if (o instanceof Expression) {
                b.append(Classes.toString((Object[])((Expression)o).getArray(e), true, this.mode));
                continue;
            }
            b.append(o);
        }
        return b.toString();
    }

    public List<MessageComponent> getMessageComponents(Event e) {
        if (this.isSimple) {
            assert (this.simpleUnformatted != null);
            return ChatMessages.parse(this.simpleUnformatted);
        }
        Object[] string = this.stringUnformatted;
        assert (string != null);
        ArrayList<MessageComponent> message = new ArrayList<MessageComponent>(this.components.length);
        int stringPart = -1;
        MessageComponent previous = null;
        for (MessageComponent component : this.components) {
            if (component == null) {
                int start;
                ++stringPart;
                if (previous != null) {
                    ++stringPart;
                }
                Object o = string[stringPart];
                previous = null;
                String text = null;
                if (o instanceof ExprColoured && ((ExprColoured)o).isUnsafeFormat()) {
                    String unformatted = Classes.toString((Object[])((ExprColoured)o).getArray(e), true, this.mode);
                    if (unformatted == null) continue;
                    message.addAll(ChatMessages.parse(unformatted));
                    continue;
                }
                if (o instanceof Expression) {
                    text = Classes.toString((Object[])((Expression)o).getArray(e), true, this.mode);
                } else assert (false);
                assert (text != null);
                MessageComponent plain = ChatMessages.plainText(text);
                if (!message.isEmpty()) {
                    ChatMessages.copyStyles((MessageComponent)message.get(message.size() - 1), plain);
                } else if (Utils.HEX_SUPPORTED && text.contains("\u00a7x") && (start = text.lastIndexOf("\u00a7x")) + 14 < text.length()) {
                    String replace = text.substring(start + 2, start + 14);
                    plain.color = Utils.parseHexColor(replace.replace("&", "").replace("\u00a7", ""));
                    plain.text = text.replace("\u00a7x" + replace, "");
                }
                message.add(plain);
                continue;
            }
            message.add(component);
            previous = component;
        }
        return message;
    }

    public List<MessageComponent> getMessageComponentsUnsafe(Event e) {
        if (this.isSimple) {
            assert (this.simpleUnformatted != null);
            return ChatMessages.parse(this.simpleUnformatted);
        }
        return ChatMessages.parse(this.toUnformattedString(e));
    }

    public String toChatString(Event e) {
        return ChatMessages.toJson(this.getMessageComponents(e));
    }

    @Nullable
    private static ChatColor getLastColor(CharSequence s) {
        for (int i = s.length() - 2; i >= 0; --i) {
            ChatColor c;
            if (s.charAt(i) != '\u00a7' || (c = ChatColor.getByChar((char)s.charAt(i + 1))) == null || !c.isColor() && c != ChatColor.RESET) continue;
            return c;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (this.isSimple) {
            assert (this.simple != null);
            return '\"' + this.simple + '\"';
        }
        Object[] string = this.string;
        assert (string != null);
        StringBuilder b = new StringBuilder("\"");
        for (Object o : string) {
            if (o instanceof Expression) {
                b.append("%").append(((Expression)o).toString(e, debug)).append("%");
                continue;
            }
            b.append(o);
        }
        b.append('\"');
        return b.toString();
    }

    public String getDefaultVariableName() {
        if (this.isSimple) {
            assert (this.simple != null);
            return this.simple;
        }
        Object[] string = this.string;
        assert (string != null);
        StringBuilder b = new StringBuilder();
        for (Object o : string) {
            if (o instanceof Expression) {
                b.append("<").append(Classes.getSuperClassInfo(((Expression)o).getReturnType()).getCodeName()).append(">");
                continue;
            }
            b.append(o);
        }
        return b.toString();
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public StringMode getMode() {
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableString setMode(StringMode mode) {
        if (this.mode == mode || this.isSimple) {
            return this;
        }
        BlockingLogHandler h = new BlockingLogHandler().start();
        try {
            VariableString vs = VariableString.newInstance(this.orig, mode);
            if (vs == null) {
                assert (false) : this + "; " + (Object)((Object)mode);
                VariableString variableString = this;
                return variableString;
            }
            VariableString variableString = vs;
            return variableString;
        }
        finally {
            h.stop();
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSingle(Event e) {
        return this.toString(e);
    }

    public String[] getArray(Event e) {
        return new String[]{this.toString(e)};
    }

    public String[] getAll(Event e) {
        return new String[]{this.toString(e)};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean check(Event e, Checker<? super String> c, boolean negated) {
        return SimpleExpression.check(this.getAll(e), c, negated, false);
    }

    @Override
    public boolean check(Event e, Checker<? super String> c) {
        return SimpleExpression.check(this.getAll(e), c, false, false);
    }

    @Override
    @Nullable
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        if (CollectionUtils.containsSuperclass(to, String.class)) {
            return this;
        }
        return null;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getAnd() {
        return true;
    }

    @Override
    public boolean setTime(int time) {
        return false;
    }

    @Override
    public int getTime() {
        return 0;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public Iterator<? extends String> iterator(Event e) {
        return new SingleItemIterator<String>(this.toString(e));
    }

    @Override
    public boolean isLoopOf(String s) {
        return false;
    }

    @Override
    public Expression<?> getSource() {
        return this;
    }

    public static <T> Expression<T> setStringMode(Expression<T> e, StringMode mode) {
        if (e instanceof ExpressionList) {
            Expression<T>[] ls = ((ExpressionList)e).getExpressions();
            for (int i = 0; i < ls.length; ++i) {
                Expression l = ls[i];
                assert (l != null);
                ls[i] = VariableString.setStringMode(l, mode);
            }
        } else if (e instanceof VariableString) {
            return ((VariableString)e).setMode(mode);
        }
        return e;
    }

    @Override
    public Expression<String> simplify() {
        return this;
    }
}

