/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.FunctionReference;
import ch.njol.skript.lang.function.JavaFunction;
import ch.njol.skript.lang.function.Namespace;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.lang.function.ScriptFunction;
import ch.njol.skript.lang.function.Signature;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Functions {
    private static final String INVALID_FUNCTION_DEFINITION = "Invalid function definition. Please check for typos and make sure that the function's name only contains letters and underscores. Refer to the documentation for more information.";
    @Nullable
    public static ScriptFunction<?> currentFunction = null;
    private static final Map<Namespace.Key, Namespace> namespaces = new HashMap<Namespace.Key, Namespace>();
    private static final Namespace javaNamespace = new Namespace();
    private static final Map<String, Namespace> globalFunctions;
    static boolean callFunctionEvents;
    public static final String functionNamePattern = "[\\p{IsAlphabetic}][\\p{IsAlphabetic}\\p{IsDigit}_]*";
    private static final Pattern functionPattern;
    private static final Pattern paramPattern;
    private static final Collection<FunctionReference<?>> toValidate;

    private Functions() {
    }

    public static JavaFunction<?> registerFunction(JavaFunction<?> function) {
        Skript.checkAcceptRegistrations();
        String name = function.getName();
        if (!name.matches(functionNamePattern)) {
            throw new SkriptAPIException("Invalid function name '" + name + "'");
        }
        javaNamespace.addSignature(function.getSignature());
        javaNamespace.addFunction(function);
        globalFunctions.put(function.getName(), javaNamespace);
        return function;
    }

    @Nullable
    public static Function<?> loadFunction(SectionNode node) {
        SkriptLogger.setNode(node);
        String key = node.getKey();
        String definition = ScriptLoader.replaceOptions(key == null ? "" : key);
        assert (definition != null);
        Matcher m = functionPattern.matcher(definition);
        if (!m.matches()) {
            return Functions.error(INVALID_FUNCTION_DEFINITION);
        }
        String name = "" + m.group(1);
        Namespace namespace = globalFunctions.get(name);
        if (namespace == null) {
            return null;
        }
        Signature<?> sign = namespace.getSignature(name);
        if (sign == null) {
            return null;
        }
        Object[] params = sign.parameters;
        ClassInfo c = sign.returnType;
        if (Skript.debug() || node.debug()) {
            Skript.debug("function " + name + "(" + StringUtils.join(params, ", ") + ")" + (c != null ? " :: " + (sign.isSingle() ? c.getName().getSingular() : c.getName().getPlural()) : "") + ":");
        }
        ScriptFunction f = new ScriptFunction(sign, node);
        namespace.addFunction(f);
        return f;
    }

    @Nullable
    public static Signature<?> loadSignature(String script, SectionNode node) {
        boolean singleReturn;
        ClassInfo<?> returnClass;
        SkriptLogger.setNode(node);
        String key = node.getKey();
        String definition = ScriptLoader.replaceOptions(key == null ? "" : key);
        Matcher m = functionPattern.matcher(definition);
        if (!m.matches()) {
            return Functions.signError(INVALID_FUNCTION_DEFINITION);
        }
        String name = "" + m.group(1);
        if (globalFunctions.containsKey(name)) {
            Namespace namespace = globalFunctions.get(name);
            if (namespace == javaNamespace) {
                return Functions.signError("Function name '" + name + "' is reserved by Skript");
            }
            Signature<?> sign = namespace.getSignature(name);
            assert (sign != null) : "globalFunctions points to a wrong namespace";
            return Functions.signError("A function named '" + name + "' already exists in script '" + sign.script + "'");
        }
        String args = m.group(2);
        String returnType = m.group(3);
        ArrayList params = new ArrayList();
        int j = 0;
        int i = 0;
        while (i <= args.length()) {
            if (i == -1) {
                return Functions.signError("Invalid text/variables/parentheses in the arguments of this function");
            }
            if (i == args.length() || args.charAt(i) == ',') {
                String arg = args.substring(j, i);
                if (arg.isEmpty()) break;
                Matcher n = paramPattern.matcher(arg);
                if (!n.matches()) {
                    return Functions.signError("The " + StringUtils.fancyOrderNumber(params.size() + 1) + " argument's definition is invalid. It should look like 'name: type' or 'name: type = default value'.");
                }
                String paramName = "" + n.group(1);
                for (Parameter parameter : params) {
                    if (!parameter.name.toLowerCase(Locale.ENGLISH).equals(paramName.toLowerCase(Locale.ENGLISH))) continue;
                    return Functions.signError("Each argument's name must be unique, but the name '" + paramName + "' occurs at least twice.");
                }
                ClassInfo<?> c = Classes.getClassInfoFromUserInput("" + n.group(2));
                NonNullPair<String, Boolean> nonNullPair = Utils.getEnglishPlural("" + n.group(2));
                if (c == null) {
                    c = Classes.getClassInfoFromUserInput(nonNullPair.getFirst());
                }
                if (c == null) {
                    return Functions.signError("Cannot recognise the type '" + n.group(2) + "'");
                }
                String rParamName = paramName.endsWith("*") ? paramName.substring(0, paramName.length() - 3) + (nonNullPair.getSecond() == false ? "::1" : "") : paramName;
                Parameter<?> p = Parameter.newInstance(rParamName, c, nonNullPair.getSecond() == false, n.group(3));
                if (p == null) {
                    return null;
                }
                params.add(p);
                j = i + 1;
            }
            if (i == args.length()) break;
            i = SkriptParser.next(args, i, ParseContext.DEFAULT);
        }
        if (returnType == null) {
            returnClass = null;
            singleReturn = false;
        } else {
            returnClass = Classes.getClassInfoFromUserInput(returnType);
            NonNullPair<String, Boolean> p = Utils.getEnglishPlural(returnType);
            boolean bl = singleReturn = p.getSecond() == false;
            if (returnClass == null) {
                returnClass = Classes.getClassInfoFromUserInput(p.getFirst());
            }
            if (returnClass == null) {
                return Functions.signError("Cannot recognise the type '" + returnType + "'");
            }
        }
        Signature sign = new Signature(script, name, params.toArray(new Parameter[0]), returnClass, singleReturn);
        Namespace.Key namespaceKey = new Namespace.Key(Namespace.Origin.SCRIPT, script);
        Namespace namespace = namespaces.computeIfAbsent(namespaceKey, k -> new Namespace());
        namespace.addSignature(sign);
        globalFunctions.put(name, namespace);
        Skript.debug("Registered function signature: " + name);
        return sign;
    }

    @Nullable
    private static Function<?> error(String error) {
        Skript.error(error);
        return null;
    }

    @Nullable
    private static Signature<?> signError(String error) {
        Skript.error(error);
        return null;
    }

    @Nullable
    public static Function<?> getFunction(String name) {
        Namespace namespace = globalFunctions.get(name);
        if (namespace == null) {
            return null;
        }
        return namespace.getFunction(name);
    }

    @Nullable
    public static Signature<?> getSignature(String name) {
        Namespace namespace = globalFunctions.get(name);
        if (namespace == null) {
            return null;
        }
        return namespace.getSignature(name);
    }

    public static int clearFunctions(String script) {
        Namespace namespace = namespaces.remove(new Namespace.Key(Namespace.Origin.SCRIPT, script));
        if (namespace == null) {
            return 0;
        }
        globalFunctions.values().removeIf(loopedNamespaced -> loopedNamespaced == namespace);
        for (Signature<?> sign : namespace.getSignatures()) {
            for (FunctionReference<?> ref : sign.calls) {
                if (script.equals(ref.script)) continue;
                toValidate.add(ref);
            }
        }
        return namespace.getSignatures().size();
    }

    public static void validateFunctions() {
        for (FunctionReference<?> c : toValidate) {
            c.validateFunction(false);
        }
        toValidate.clear();
    }

    public static void clearFunctions() {
        globalFunctions.values().removeIf(namespace -> namespace != javaNamespace);
        namespaces.clear();
        assert (toValidate.isEmpty()) : toValidate;
        toValidate.clear();
    }

    public static Collection<JavaFunction<?>> getJavaFunctions() {
        return javaNamespace.getFunctions();
    }

    public static void enableFunctionEvents(SkriptAddon addon) {
        if (addon == null) {
            throw new SkriptAPIException("enabling function events requires addon instance");
        }
        callFunctionEvents = true;
    }

    static {
        namespaces.put(new Namespace.Key(Namespace.Origin.JAVA, "unknown"), javaNamespace);
        globalFunctions = new HashMap<String, Namespace>();
        callFunctionEvents = false;
        functionPattern = Pattern.compile("function ([\\p{IsAlphabetic}][\\p{IsAlphabetic}\\p{IsDigit}_]*)\\((.*)\\)(?: :: (.+))?", 2);
        paramPattern = Pattern.compile("\\s*(.+?)\\s*:(?=[^:]*$)\\s*(.+?)(?:\\s*=\\s*(.+))?\\s*");
        toValidate = new ArrayList();
    }
}

