/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.parser;

import ch.njol.skript.config.Config;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Loop;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.log.HandlerList;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class ParserInstance {
    private static final ThreadLocal<ParserInstance> parserInstances = ThreadLocal.withInitial(ParserInstance::new);
    private final HandlerList handlers = new HandlerList();
    @Nullable
    private Node node;
    @Nullable
    private Config currentScript;
    private final HashMap<String, String> currentOptions = new HashMap();
    @Nullable
    private String currentEventName;
    @Nullable
    private Class<? extends Event>[] currentEvents;
    @Nullable
    private SkriptEvent currentSkriptEvent;
    private List<TriggerSection> currentSections = new ArrayList<TriggerSection>();
    private List<Loop> currentLoops = new ArrayList<Loop>();
    private Kleenean hasDelayBefore = Kleenean.FALSE;
    private String indentation = "";
    private static final Map<Class<? extends Data>, Function<ParserInstance, ? extends Data>> dataRegister = new HashMap<Class<? extends Data>, Function<ParserInstance, ? extends Data>>();
    private final Map<Class<? extends Data>, Data> dataMap = new HashMap<Class<? extends Data>, Data>();

    public static ParserInstance get() {
        return parserInstances.get();
    }

    public HandlerList getHandlers() {
        return this.handlers;
    }

    @Nullable
    public Node getNode() {
        return this.node;
    }

    @Nullable
    public Config getCurrentScript() {
        return this.currentScript;
    }

    public HashMap<String, String> getCurrentOptions() {
        return this.currentOptions;
    }

    @Nullable
    public String getCurrentEventName() {
        return this.currentEventName;
    }

    @Nullable
    public Class<? extends Event>[] getCurrentEvents() {
        return this.currentEvents;
    }

    @Nullable
    public SkriptEvent getCurrentSkriptEvent() {
        return this.currentSkriptEvent;
    }

    public List<TriggerSection> getCurrentSections() {
        return this.currentSections;
    }

    public List<Loop> getCurrentLoops() {
        return this.currentLoops;
    }

    public Kleenean getHasDelayBefore() {
        return this.hasDelayBefore;
    }

    public String getIndentation() {
        return this.indentation;
    }

    public void setNode(@Nullable Node node) {
        this.node = node == null || node.getParent() == null ? null : node;
    }

    public void setCurrentScript(@Nullable Config currentScript) {
        this.currentScript = currentScript;
        this.getDataInstances().forEach(data -> data.onCurrentScriptChange(currentScript));
    }

    public void setCurrentEventName(@Nullable String currentEventName) {
        this.currentEventName = currentEventName;
    }

    public void setCurrentEvents(@Nullable Class<? extends Event>[] currentEvents) {
        this.currentEvents = currentEvents;
        this.getDataInstances().forEach(data -> data.onCurrentEventsChange(currentEvents));
    }

    public void setCurrentSkriptEvent(@Nullable SkriptEvent currentSkriptEvent) {
        this.currentSkriptEvent = currentSkriptEvent;
    }

    public void deleteCurrentSkriptEvent() {
        this.currentSkriptEvent = null;
    }

    public void setCurrentSections(List<TriggerSection> currentSections) {
        this.currentSections = currentSections;
    }

    public void setCurrentLoops(List<Loop> currentLoops) {
        this.currentLoops = currentLoops;
    }

    public void setHasDelayBefore(Kleenean hasDelayBefore) {
        this.hasDelayBefore = hasDelayBefore;
    }

    public void setIndentation(String indentation) {
        this.indentation = indentation;
    }

    @SafeVarargs
    public final void setCurrentEvent(String name, Class<? extends Event> ... events) {
        this.currentEventName = name;
        this.setCurrentEvents(events);
        this.hasDelayBefore = Kleenean.FALSE;
    }

    public void deleteCurrentEvent() {
        this.currentEventName = null;
        this.setCurrentEvents(null);
        this.hasDelayBefore = Kleenean.FALSE;
    }

    public boolean isCurrentEvent(@Nullable Class<? extends Event> event) {
        return CollectionUtils.containsSuperclass(this.currentEvents, event);
    }

    @SafeVarargs
    public final boolean isCurrentEvent(Class<? extends Event> ... events) {
        return CollectionUtils.containsAnySuperclass(this.currentEvents, events);
    }

    public static <T extends Data> void registerData(Class<T> dataClass, Function<ParserInstance, T> dataFunction) {
        dataRegister.put(dataClass, dataFunction);
    }

    public static boolean isRegistered(Class<? extends Data> dataClass) {
        return dataRegister.containsKey(dataClass);
    }

    public <T extends Data> T getData(Class<T> dataClass) {
        if (this.dataMap.containsKey(dataClass)) {
            return (T)this.dataMap.get(dataClass);
        }
        if (dataRegister.containsKey(dataClass)) {
            Data data = dataRegister.get(dataClass).apply(this);
            this.dataMap.put(dataClass, data);
            return (T)data;
        }
        assert (false);
        return null;
    }

    private List<? extends Data> getDataInstances() {
        ArrayList<Data> dataList = new ArrayList<Data>();
        for (Class<? extends Data> dataClass : dataRegister.keySet()) {
            Data data = this.getData(dataClass);
            if (data == null) continue;
            dataList.add(data);
        }
        return dataList;
    }

    public static abstract class Data {
        private final ParserInstance parserInstance;

        public Data(ParserInstance parserInstance) {
            this.parserInstance = parserInstance;
        }

        protected final ParserInstance getParser() {
            return this.parserInstance;
        }

        public void onCurrentScriptChange(@Nullable Config currentScript) {
        }

        public void onCurrentEventsChange(@Nullable Class<? extends Event>[] currentEvents) {
        }
    }
}

